/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentMap;

public class ClassLoaderUtils {
    private static final ConcurrentMap<URL, ClassLoader> CACHE = CommonUtils.concurrentMap();

    public static ClassLoader getClassLoader(File file) {
        try {
            return ClassLoaderUtils.getClassLoader(file.toURI().toURL(), Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader(File file, ClassLoader parentClassLoader) {
        try {
            return ClassLoaderUtils.getClassLoader(file.toURI().toURL(), parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader(URL url) {
        return ClassLoaderUtils.getClassLoader(url, Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getClassLoader(URL url, ClassLoader parentClassLoader) {
        ClassLoader classLoader = (ClassLoader)CACHE.get(url);
        if (classLoader != null) {
            return classLoader;
        }
        classLoader = URLClassLoader.newInstance(new URL[]{url}, parentClassLoader);
        ClassLoader org = CACHE.put(url, classLoader);
        return org != null ? org : classLoader;
    }

    public static ClassLoader reloadClassLoader(URL url, ClassLoader parentClassLoader) {
        CACHE.remove(url);
        return ClassLoaderUtils.getClassLoader(url, parentClassLoader);
    }
}

