/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractClassFinder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileClassSearcher;
import com.sqlapp.util.JarClassSearcher;
import com.sqlapp.util.Searcher;
import com.sqlapp.util.VfsClassSearcher;
import java.util.List;
import java.util.Set;

public class ClassFinder
extends AbstractClassFinder<Class<?>> {
    public ClassFinder() {
    }

    public ClassFinder(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected void itialize() {
        this.addResourceSearcher((Searcher)new VfsClassSearcher());
        this.addResourceSearcher((Searcher)new JarClassSearcher());
        this.addResourceSearcher((Searcher)new FileClassSearcher());
    }

    public <T> List<Class<? extends T>> find(String packageName) {
        ClassLoader classLoader = this.classLoader;
        List<Class<? extends T>> list = this.findClasses(classLoader, packageName, false);
        return list;
    }

    public <T> List<Class<? extends T>> findRecursive(String packageName) {
        ClassLoader classLoader = this.classLoader;
        List<Class<? extends T>> list = this.findClasses(classLoader, packageName, true);
        return list;
    }

    @Override
    protected void merge(List<Class<?>> classes, List<Class<?>> addClasses) {
        Set names = CommonUtils.set();
        for (Class<?> clazz : classes) {
            names.add(clazz.getName());
        }
        for (Class<?> clazz : addClasses) {
            if (names.contains(clazz.getName())) continue;
            classes.add(clazz);
        }
    }

    @Override
    protected void initialize(Searcher<Class<?>> searcher) {
    }
}

