/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractStringSet
implements Set<String>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 610779830671683832L;
    protected Set<String> inner = null;

    public AbstractStringSet() {
        this.inner = CommonUtils.set();
    }

    public AbstractStringSet(int capacity) {
        this.inner = CommonUtils.set(capacity);
    }

    public AbstractStringSet(int capacity, float loadFactor) {
        this.inner = CommonUtils.set(capacity, loadFactor);
    }

    public AbstractStringSet(Set<String> baseSet) {
        this.inner = baseSet;
    }

    protected abstract String convertKey(String var1);

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public boolean contains(String o) {
        return this.inner.contains(this.convertKey(o));
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(this.convertKey((String)o));
    }

    @Override
    public Iterator<String> iterator() {
        return this.inner.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean add(String e) {
        return this.inner.add(this.convertKey(e));
    }

    public boolean remove(String o) {
        return this.inner.remove(this.convertKey(o));
    }

    @Override
    public boolean remove(Object o) {
        return this.inner.remove(this.convertKey((String)o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object val : c) {
            if (this.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        for (String string : c) {
            this.add(string);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List list = CommonUtils.list();
        for (Object val : c) {
            list.add(this.convertKey((String)val));
        }
        return this.inner.retainAll(list);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        List list = CommonUtils.list();
        for (Object val : c) {
            list.add(this.convertKey((String)val));
        }
        return this.inner.removeAll(list);
    }

    public String toString() {
        return this.inner.toString();
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    public abstract AbstractStringSet newInstance();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractStringSet)) {
            return false;
        }
        return this.inner.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.inner.hashCode();
    }
}

