/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStringMap<T>
implements Map<String, T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -602530703582075583L;
    protected Map<String, T> inner = null;

    public AbstractStringMap() {
        this.inner = CommonUtils.linkedMap();
    }

    public AbstractStringMap(int capacity) {
        this.inner = CommonUtils.linkedMap(capacity);
    }

    public AbstractStringMap(int capacity, float loadFactor) {
        this.inner = CommonUtils.linkedMap(capacity);
    }

    public AbstractStringMap(Map<String, T> baseMap) {
        this.inner = baseMap;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    protected abstract String convertKey(String var1);

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(this.convertKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inner.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.inner.get(this.convertKey((String)key));
    }

    @Override
    public T put(String key, T value) {
        return this.inner.put(this.convertKey(key), value);
    }

    public T remove(String key) {
        return this.inner.remove(this.convertKey(key));
    }

    @Override
    public T remove(Object key) {
        return this.inner.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.inner.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.inner.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.inner.entrySet();
    }

    public String toString() {
        return this.inner.toString();
    }

    public abstract AbstractStringMap<T> newInstance();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        return this.inner.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.inner.hashCode();
    }
}

