/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DefaultPredicate;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.ResourceFinder;
import com.sqlapp.util.ResourceSearcher;
import java.util.Set;
import java.util.function.Predicate;

abstract class AbstractResourceSearcher
implements ResourceSearcher {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Predicate<ResourceFinder.ResourceInfo> filter = new DefaultPredicate<ResourceFinder.ResourceInfo>();
    private String[] extensions = new String[]{"properties"};
    private Set<String> extensionSets = CommonUtils.set(this.extensions);

    AbstractResourceSearcher() {
    }

    public Set<String> getExtensionSets() {
        return this.extensionSets;
    }

    @Override
    public void setExtensionSets(Set<String> extensionSets) {
        this.extensionSets = extensionSets;
    }

    public Predicate<ResourceFinder.ResourceInfo> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Predicate<ResourceFinder.ResourceInfo> filter) {
        this.filter = filter;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected String fileNameToClassName(String name) {
        return name.substring(0, name.length() - ".class".length());
    }

    protected boolean isClassFile(String fileName) {
        return fileName.endsWith(".class");
    }

    protected boolean isResourceFile(String fileName) {
        if (CommonUtils.isEmpty(fileName)) {
            return false;
        }
        if (fileName.endsWith("/")) {
            return false;
        }
        String ext = FileUtils.getExtension(fileName);
        if (CommonUtils.isEmpty(this.getExtensionSets())) {
            return true;
        }
        return this.getExtensionSets().contains(ext);
    }

    protected String getFileName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    protected String getPackage(String name) {
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            return name.substring(0, pos).replace("/", ".");
        }
        return name;
    }
}

