/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.ClassSearcher;
import com.sqlapp.util.DefaultPredicate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;

abstract class AbstractClassSearcher
implements ClassSearcher {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Predicate<Class<?>> filter = new DefaultPredicate();
    private Consumer<Throwable> exceptionHandler = e -> {};
    private Method getNextEntryMethod = null;

    AbstractClassSearcher() {
    }

    public Predicate<Class<?>> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Predicate<Class<?>> filter) {
        this.filter = filter;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected String fileNameToClassName(String name) {
        return name.substring(0, name.length() - ".class".length());
    }

    protected boolean isClassFile(String fileName) {
        return fileName.endsWith(".class");
    }

    public Consumer<Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected JarEntry getNextJarEntry(Object obj) {
        if (this.getNextEntryMethod == null) {
            try {
                this.getNextEntryMethod = obj.getClass().getMethod("getNextJarEntry", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (JarEntry)this.getNextEntryMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

