/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.Node;
import com.sqlapp.jdbc.sql.node.SqlPartNode;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.Set;

public class SqlNode
extends Node {
    private static final long serialVersionUID = 1L;
    private Set<ParameterDefinition> parameters;

    public SqlNode() {
    }

    public SqlNode(String sql) {
        SqlPartNode sqlPart = new SqlPartNode();
        sqlPart.setSql(sql);
        this.addChildNode(sqlPart);
    }

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        List<Node> nodes = this.getChildNodes();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Node child = nodes.get(i);
            child.eval(context, sqlParameters);
        }
        return true;
    }

    public Set<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(Set<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public ParameterDefinition getOffsetParameter() {
        return this.getParameterByName("_offset");
    }

    public ParameterDefinition getRowParameter() {
        return this.getParameterByName("_row");
    }

    public ParameterDefinition getCountSqlParameter() {
        return this.getParameterByName("_countSql");
    }

    public ParameterDefinition getParameterByName(String name) {
        for (ParameterDefinition def : this.parameters) {
            if (!name.equals(def.getName())) continue;
            return def;
        }
        return null;
    }

    @Override
    public SqlNode clone() {
        SqlNode clone = (SqlNode)SqlNode.class.cast(super.clone());
        if (this.getParameters() != null) {
            clone.parameters = CommonUtils.linkedSet();
            for (ParameterDefinition def : this.getParameters()) {
                clone.getParameters().add(def.clone());
            }
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        List<Node> nodes = this.getChildNodes();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Node child = nodes.get(i);
            builder.append(child.toString());
        }
        return builder.toString();
    }
}

