/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.CommentNode;

public class OutputVariableNode
extends CommentNode
implements Cloneable {
    private static final long serialVersionUID = 1700573849729755073L;

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        Object val = this.evalExpression(this.getExpression(), context);
        if (val != null) {
            String strVal = Converters.getDefault().convertString(val, val.getClass());
            sqlParameters.addSql(this.sanitizeSimple(strVal));
        }
        return true;
    }

    protected String sanitizeSimple(String text) {
        if (text.startsWith("'") && text.endsWith("'")) {
            return "'" + this.sanitizeSimpleInternal(text.substring(1, text.length() - 1)) + "'";
        }
        return this.sanitizeSimpleInternal(text);
    }

    private String sanitizeSimpleInternal(String text) {
        return text.replace("--", "").replace(";", "").replace("\\", "").replace("%", "").replace("?", "");
    }

    @Override
    public OutputVariableNode clone() {
        return (OutputVariableNode)super.clone();
    }
}

