/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.exceptions.ExpressionExecutionException;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.ElseIfNode;
import com.sqlapp.jdbc.sql.node.ElseNode;
import com.sqlapp.jdbc.sql.node.NeedsEndNode;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public class IfNode
extends NeedsEndNode {
    private static final long serialVersionUID = -2951149147210439845L;
    private List<ElseIfNode> elseIfNodes = CommonUtils.list();
    private ElseNode elseNode = null;

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        sqlParameters.addSql(' ');
        boolean eval = this.evalBoolean(context);
        if (eval) {
            return this.evalChilds(context, sqlParameters);
        }
        int size = this.elseIfNodes.size();
        for (int i = 0; i < size; ++i) {
            ElseIfNode elseIfNode = this.elseIfNodes.get(i);
            if (!elseIfNode.eval(context, sqlParameters)) continue;
            return true;
        }
        if (this.elseNode != null) {
            return this.elseNode.eval(context, sqlParameters);
        }
        return false;
    }

    public List<ElseIfNode> getElseIfNodes() {
        return this.elseIfNodes;
    }

    protected boolean evalBoolean(Object context) {
        try {
            return this.getEvaluator().getEvalExecutor(this.getExpression()).evalBoolean(context);
        }
        catch (ExpressionExecutionException e) {
            throw this.handleExceptrion(e);
        }
    }

    public ElseNode getElseNode() {
        return this.elseNode;
    }

    public void setElseNode(ElseNode elseNode) {
        this.elseNode = elseNode;
    }

    @Override
    public IfNode clone() {
        return (IfNode)super.clone();
    }

    @Override
    public void setExpression(String expression) {
        super.setExpression(expression);
        this.setParameterDefinition(new ParameterDefinition(expression));
    }
}

