/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.ResultSetConcurrency;
import com.sqlapp.jdbc.sql.ResultSetHoldability;
import com.sqlapp.jdbc.sql.ResultSetType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.ToStringBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlParameterCollection
implements Serializable,
Closeable {
    private static final long serialVersionUID = -4215029691132143165L;
    private List<BindParameter> parameters = new ArrayList<BindParameter>();
    private StringBuilder sql = new StringBuilder();
    private Integer fetchSize;
    private ResultSetType resultSetType = null;
    private ResultSetConcurrency resultSetConcurrency = null;
    private ResultSetHoldability resultSetHoldability = null;
    private Object inputStream;
    private Object outputStream;
    private Dialect dialect = null;
    private static final Pattern pattern = Pattern.compile("^[ \t]*(\n|\r)", 8);

    public SqlParameterCollection() {
    }

    public SqlParameterCollection(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getSql() {
        return this.sql.toString();
    }

    public SqlParameterCollection addSql(CharSequence value, boolean condition) {
        Matcher matcher;
        char c;
        Matcher matcher2;
        if (!condition) {
            return this;
        }
        if (CommonUtils.isEmpty(this.sql) ? (matcher2 = pattern.matcher(value)).matches() : ('\n' == (c = this.sql.charAt(this.sql.length() - 1)) || '\r' == c) && (matcher = pattern.matcher(value)).matches()) {
            return this;
        }
        this.sql.append(value);
        return this;
    }

    public SqlParameterCollection addSql(CharSequence value) {
        return this.addSql(value, true);
    }

    public SqlParameterCollection addSql(char c) {
        return this.addSql(c, true);
    }

    public SqlParameterCollection addSql(char c, boolean condition) {
        if (!condition) {
            return this;
        }
        this.sql.append(c);
        return this;
    }

    public SqlParameterCollection add(BindParameter parameter) {
        int pos = this.parameters.size();
        StringBuilder bindName = new StringBuilder();
        bindName.append('?');
        parameter.setBindingName(bindName.toString());
        parameter.setOrdinal(pos);
        this.parameters.add(parameter);
        this.addSql(parameter.getBindingName());
        return this;
    }

    public SqlParameterCollection addAll(BindParameter ... parameters) {
        if (CommonUtils.isEmpty(parameters)) {
            return this;
        }
        int i = 0;
        for (BindParameter parameter : parameters) {
            if (i > 0) {
                this.addSql(',');
            }
            this.add(parameter);
            ++i;
        }
        return this;
    }

    public SqlParameterCollection addAll(Collection<BindParameter> parameters) {
        if (CommonUtils.isEmpty(parameters)) {
            return this;
        }
        int i = 0;
        for (BindParameter parameter : parameters) {
            if (i > 0) {
                this.addSql(',');
            }
            this.add(parameter);
            ++i;
        }
        return this;
    }

    public SqlParameterCollection add(String name, Object value) {
        BindParameter dbParameter = new BindParameter();
        dbParameter.setName(name);
        if (value instanceof String && this.dialect != null && this.dialect.recommendsNTypeChar()) {
            dbParameter.setType(DataType.NVARCHAR);
        }
        dbParameter.setValue(value);
        return this.add(dbParameter);
    }

    public SqlParameterCollection merge(SqlParameterCollection sqlParameters) {
        this.sql.append(sqlParameters.getSql());
        for (BindParameter parameter : sqlParameters.getBindParameters()) {
            this.add(parameter);
        }
        return this;
    }

    public ResultSetType getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
    }

    public ResultSetConcurrency getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(ResultSetConcurrency resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public ResultSetHoldability getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(ResultSetHoldability resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public Object getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(Object inputStream) {
        this.inputStream = inputStream;
    }

    public Object getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(Object outputStream) {
        this.outputStream = outputStream;
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.sql);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SqlParameterCollection)) {
            return false;
        }
        SqlParameterCollection val = (SqlParameterCollection)obj;
        if (!CommonUtils.eq(this.sql, val.sql)) {
            return false;
        }
        if (!CommonUtils.eq(this.parameters, val.parameters)) {
            return false;
        }
        if (!CommonUtils.eq(this.getFetchSize(), val.getFetchSize())) {
            return false;
        }
        if (!CommonUtils.eq(this.getResultSetConcurrency(), val.getResultSetConcurrency())) {
            return false;
        }
        if (!CommonUtils.eq(this.getResultSetHoldability(), val.getResultSetHoldability())) {
            return false;
        }
        if (!CommonUtils.eq(this.getResultSetType(), val.getResultSetType())) {
            return false;
        }
        if (!CommonUtils.eq(this.getInputStream(), val.getInputStream())) {
            return false;
        }
        return CommonUtils.eq(this.getOutputStream(), val.getOutputStream());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("sql", (Object)this.sql);
        builder.add("parameters", this.parameters);
        builder.add("fetchSize", (Object)this.getFetchSize());
        builder.add("resultSetType", (Object)this.getResultSetType());
        builder.add("resultSetConcurrency", (Object)this.getResultSetConcurrency());
        builder.add("resultSetHoldability", (Object)this.getResultSetHoldability());
        return builder.toString();
    }

    public List<BindParameter> getBindParameters() {
        return this.parameters;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setBindParameters(List<BindParameter> parameters) {
        this.parameters = parameters;
    }

    public void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    @Override
    public void close() throws IOException {
        this.getBindParameters().forEach(c -> {
            if (c.getValue() instanceof InputStream) {
                FileUtils.close((InputStream)c.getValue());
            } else if (c.getValue() instanceof Reader) {
                FileUtils.close((Reader)c.getValue());
            }
        });
        if (this.getInputStream() instanceof Closeable && System.in != this.getInputStream()) {
            FileUtils.close((Closeable)this.getInputStream());
        }
        if (this.getOutputStream() instanceof Closeable && System.out != this.getOutputStream()) {
            FileUtils.close((Closeable)this.getOutputStream());
        }
    }
}

