/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.converter.EnumConvertable;

public enum ResultSetType implements EnumConvertable<Integer>
{
    TYPE_FORWARD_ONLY(1003),
    TYPE_SCROLL_SENSITIVE(1005),
    TYPE_SCROLL_INSENSITIVE(1004);

    private final Integer value;
    private final String text;

    private ResultSetType(int value) {
        this.value = value;
        this.text = this.name().replace("_", "");
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static ResultSetType parse(Integer value) {
        for (ResultSetType type : ResultSetType.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        return ResultSetType.getDefault();
    }

    public static ResultSetType parse(String value) {
        if (value == null) {
            return ResultSetType.getDefault();
        }
        value = value.replace("_", "");
        for (ResultSetType type : ResultSetType.values()) {
            if (type.text.equalsIgnoreCase(value)) {
                return type;
            }
            if (!type.getValue().toString().equals(value)) continue;
            return type;
        }
        return ResultSetType.getDefault();
    }

    public static ResultSetType getDefault() {
        return TYPE_FORWARD_ONLY;
    }
}

