/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.jdbc.sql.AbstractSqlRegistry;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public class MapSqlRegistry
extends AbstractSqlRegistry {
    private ConcurrentMap<String, ConcurrentMap<String, List<String>>> dialectSqlIdMap = CommonUtils.concurrentMap();

    @Override
    public boolean contains(String sqlId) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap("Standard");
        return map.containsKey(sqlId);
    }

    @Override
    public boolean contains(String sqlId, String databaseProductName) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap(databaseProductName);
        return map.containsKey(sqlId);
    }

    @Override
    protected List<String> getInternal(String sqlId) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap("Standard");
        return (List)map.get(sqlId);
    }

    @Override
    protected List<String> getInternal(String sqlId, String databaseProductName) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap(databaseProductName);
        return (List)map.get(sqlId);
    }

    @Override
    protected void putInternal(String sqlId, String databaseProductName, String ... sql) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap(databaseProductName);
        map.put(sqlId, CommonUtils.list(sql));
    }

    private ConcurrentMap<String, List<String>> getDialectMap(String databaseProductName) {
        ConcurrentMap<String, List<String>> map;
        if (databaseProductName == null) {
            databaseProductName = "Standard";
        }
        if ((map = (ConcurrentMap<String, List<String>>)this.dialectSqlIdMap.get(databaseProductName)) == null) {
            map = CommonUtils.concurrentMap();
            ConcurrentMap<String, List<String>> org = this.dialectSqlIdMap.putIfAbsent(databaseProductName, map);
            return org != null ? org : map;
        }
        return map;
    }

    @Override
    protected void removeInternal(String sqlId) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap("Standard");
        map.remove(sqlId);
    }

    @Override
    protected void removeInternal(String sqlId, String databaseProductName) {
        ConcurrentMap<String, List<String>> map = this.getDialectMap(databaseProductName);
        map.remove(sqlId);
    }
}

