/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JdbcQueryHandler
extends JdbcHandler {
    private Integer fetchSize = null;
    private ResultSetNextHandler resultSetNextHandler = null;

    public JdbcQueryHandler(SqlNode node, ResultSetNextHandler resultSetNextHandler) {
        super(node);
        this.resultSetNextHandler = resultSetNextHandler;
    }

    public void execute(Connection connection, ParametersContext parametersContext, Integer limit, Integer offset) throws SQLException {
        try {
            this.executeQueryCallback(connection, parametersContext, limit, offset);
        }
        catch (SQLException e) {
            this.handleSqlException(e);
        }
    }

    public void execute(Connection connection, SqlParameterCollection sqlParameters, Integer limit, Integer offset) throws SQLException {
        try {
            this.executeQueryCallback(connection, sqlParameters, limit, offset);
        }
        catch (SQLException e) {
            this.handleSqlException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQueryCallback(Connection connection, SqlParameterCollection sqlParameters, Integer limit, Integer offset) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = offset != null ? this.createStatementScrollInsensitive(connection, sqlParameters) : this.createStatement(connection, sqlParameters, limit);
            this.executeQueryCallback(connection, statement, limit, offset);
        }
        catch (Throwable throwable) {
            this.close(statement, sqlParameters);
            throw throwable;
        }
        this.close(statement, sqlParameters);
    }

    protected JdbcHandler.StatementSqlParametersHolder createStatementScrollInsensitive(Connection connection, ParametersContext parametersContext) throws SQLException {
        SqlParameterCollection sqlParameters = this.getNode().eval(parametersContext);
        PreparedStatement preparedStatement = this.createStatementScrollInsensitive(connection, sqlParameters);
        return new JdbcHandler.StatementSqlParametersHolder(preparedStatement, sqlParameters);
    }

    protected PreparedStatement createStatementScrollInsensitive(Connection connection, SqlParameterCollection sqlParameters) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sqlParameters.getSql(), 1004, 1007);
        this.setBind(statement, sqlParameters);
        return statement;
    }

    public JdbcQueryHandler execute(Connection connection, ParametersContext parametersContext) {
        try {
            this.executeQueryCallback(connection, parametersContext, null, null);
            return this;
        }
        catch (SQLException e) {
            this.handleSqlException(e);
            return this;
        }
    }

    public JdbcQueryHandler execute(Connection connection) {
        this.execute(connection, new ParametersContext());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQueryCallback(Connection connection, ParametersContext parametersContext, Integer limit, Integer offset) throws SQLException {
        JdbcHandler.StatementSqlParametersHolder statementSqlParametersHolder = null;
        try {
            if (offset != null) {
                ParameterDefinition def = this.getNode().getOffsetParameter();
                if (def == null) {
                    statementSqlParametersHolder = this.createStatementScrollInsensitive(connection, parametersContext);
                } else {
                    parametersContext.put(def.getName(), (Object)offset);
                    statementSqlParametersHolder = this.createStatement(connection, parametersContext, limit);
                }
            } else {
                statementSqlParametersHolder = this.createStatement(connection, parametersContext, limit);
            }
            this.executeQueryCallback(connection, statementSqlParametersHolder.getPreparedStatement(), limit, offset);
        }
        catch (Throwable throwable) {
            this.close(statementSqlParametersHolder);
            throw throwable;
        }
        this.close(statementSqlParametersHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQueryCallback(Connection connection, PreparedStatement statement, Integer limit, Integer offset) throws SQLException {
        ExResultSet resultSet;
        block5: {
            resultSet = null;
            try {
                if (this.fetchSize != null) {
                    statement.setFetchSize(this.fetchSize);
                }
                resultSet = new ExResultSet(statement.executeQuery());
                ParameterDefinition offsetParam = this.getNode().getOffsetParameter();
                if (offset != null && offsetParam == null) {
                    resultSet.relative(offset);
                }
                ParameterDefinition limitParam = this.getNode().getRowParameter();
                if (limit != null && limitParam == null) {
                    this.handleResultSet(resultSet, limit);
                    break block5;
                }
                this.handleResultSet(resultSet);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                throw throwable;
            }
        }
        this.close(resultSet);
    }

    protected void handleResultSet(ExResultSet resultSet, int limit) throws SQLException {
        for (int i = 0; resultSet.next() && i < limit; ++i) {
            this.handleResultSetNext(resultSet);
        }
    }

    @Override
    protected void handleResultSetNext(ExResultSet resultSet) throws SQLException {
        this.resultSetNextHandler.handleResultSetNext(resultSet);
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }
}

