/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.jdbc.sql.GeneratedKeyHandler;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.AbstractIterator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JdbcBatchUpdateHandler
extends JdbcHandler {
    private int batchSize = 50;

    public JdbcBatchUpdateHandler(SqlNode node) {
        super(node);
    }

    public JdbcBatchUpdateHandler(SqlNode node, GeneratedKeyHandler generatedKeyHandler) {
        super(node, generatedKeyHandler);
    }

    @Override
    protected void doExecute(Connection connection, Object context) throws SQLException {
        try {
            if (this.batchSize > 1) {
                this.doExecuteBatch(connection, context);
            } else {
                this.doExecuteContext(connection, context);
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected void doExecuteContext(final Connection connection, Object context) throws Exception {
        AbstractIterator<Object> itr = new AbstractIterator<Object>(){
            SqlParameterCollection sqlParameters = null;
            PreparedStatement statement = null;
            String sql = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void handle(Object obj, int index) throws SQLException {
                try {
                    this.sqlParameters = JdbcBatchUpdateHandler.this.getNode().eval(obj);
                    String currentSql = this.sqlParameters.getSql();
                    if (!currentSql.equals(this.sql)) {
                        JdbcBatchUpdateHandler.this.close(this.statement, this.sqlParameters);
                    }
                    if (this.statement == null) {
                        this.statement = JdbcBatchUpdateHandler.this.getStatement(connection, this.sqlParameters, null);
                    } else {
                        this.statement.clearParameters();
                    }
                    JdbcBatchUpdateHandler.this.setBind(this.statement, this.sqlParameters);
                    JdbcBatchUpdateHandler.this.handlePreparedStatement(this.statement);
                    this.sql = currentSql;
                }
                finally {
                    JdbcBatchUpdateHandler.this.close(this.statement, this.sqlParameters);
                    this.statement = null;
                }
            }

            @Override
            protected void callStepLast(int length) throws Exception {
                JdbcBatchUpdateHandler.this.close(this.statement, this.sqlParameters);
            }
        };
        itr.execute(context);
    }

    protected void doExecuteBatch(final Connection connection, Object context) throws Exception {
        AbstractIterator<Object> itr = new AbstractIterator<Object>(this.batchSize){
            PreparedStatement statement;
            SqlParameterCollection sqlParameters;
            {
                super(step);
                this.statement = null;
                this.sqlParameters = null;
            }

            @Override
            protected void handle(Object obj, int index) throws SQLException {
                if (index == 0) {
                    this.sqlParameters = JdbcBatchUpdateHandler.this.getNode().eval(obj);
                    this.statement = JdbcBatchUpdateHandler.this.getStatement(connection, this.sqlParameters, null);
                    JdbcBatchUpdateHandler.this.setBind(this.statement, this.sqlParameters);
                } else {
                    JdbcBatchUpdateHandler.this.getNode().reEval(obj, this.sqlParameters);
                    JdbcBatchUpdateHandler.this.setBind(this.statement, this.sqlParameters);
                }
                this.statement.addBatch();
            }

            @Override
            protected void stepHandle(int index, int stepSize) throws SQLException {
                int i;
                int[] ret = this.statement.executeBatch();
                JdbcBatchUpdateHandler.this.handleGeneratedKeys(this.statement);
                this.statement.clearBatch();
                boolean hasResult = true;
                for (i = 0; i < ret.length; ++i) {
                    if (ret[i] != -2) continue;
                    hasResult = false;
                    break;
                }
                if (hasResult) {
                    for (i = 0; i < ret.length; ++i) {
                        if (ret[i] == -3) {
                            JdbcBatchUpdateHandler.this.handleUpdate(this.statement, 0L);
                            continue;
                        }
                        JdbcBatchUpdateHandler.this.handleUpdate(this.statement, ret[i]);
                    }
                } else {
                    JdbcBatchUpdateHandler.this.handleUpdate(this.statement, this.statement.getLargeUpdateCount());
                }
            }

            @Override
            protected void executeFinally() {
                JdbcBatchUpdateHandler.this.close(this.statement, this.sqlParameters);
            }
        };
        itr.execute(context);
    }
}

