/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.jdbc.sql.AbstractSqlRegistry;
import com.sqlapp.jdbc.sql.ClassPathSqlRegistry;
import com.sqlapp.util.FileUtils;
import java.util.Collections;
import java.util.List;

public class FileSqlRegistry
extends AbstractSqlRegistry {
    private String basePath = null;
    private String encoding = "UTF-8";
    private String extension = ".sql";

    @Override
    public boolean contains(String sqlId) {
        String path = FileUtils.combinePath(this.getBasePath(), sqlId + this.getExtension());
        return FileUtils.exists(path);
    }

    @Override
    public boolean contains(String sqlId, String databaseProductName) {
        String path = FileUtils.combinePath(this.getBasePath(), databaseProductName, sqlId + this.getExtension());
        return FileUtils.exists(path);
    }

    @Override
    protected List<String> getInternal(String sqlId) {
        String path = FileUtils.combinePath(this.getBasePath(), sqlId + this.getExtension());
        if (FileUtils.exists(path)) {
            String sql = FileUtils.readText(path, this.getEncoding());
            return FileSqlRegistry.splitSql(sql);
        }
        return Collections.emptyList();
    }

    private static List<String> splitSql(String sql) {
        return ClassPathSqlRegistry.splitSql(sql);
    }

    @Override
    protected List<String> getInternal(String sqlId, String databaseProductName) {
        String path = FileUtils.combinePath(this.getBasePath(), databaseProductName, sqlId + this.getExtension());
        if (FileUtils.exists(path)) {
            String sql = FileUtils.readText(path, this.getEncoding());
            return FileSqlRegistry.splitSql(sql);
        }
        return Collections.emptyList();
    }

    @Override
    protected void putInternal(String sqlId, String databaseProductName, String ... sql) {
        String path = databaseProductName == null ? FileUtils.combinePath(this.getBasePath(), sqlId + this.getExtension()) : FileUtils.combinePath(this.getBasePath(), databaseProductName, sqlId + this.getExtension());
        if (FileUtils.exists(path)) {
            FileUtils.remove(path);
        }
        FileUtils.writeText(path, this.getEncoding(), sql);
    }

    @Override
    protected void removeInternal(String sqlId) {
        String path = FileUtils.combinePath(this.getBasePath(), sqlId + this.getExtension());
        if (FileUtils.exists(path)) {
            FileUtils.remove(path);
        }
    }

    @Override
    protected void removeInternal(String sqlId, String databaseProductName) {
        String path = FileUtils.combinePath(this.getBasePath(), databaseProductName, sqlId + this.getExtension());
        if (FileUtils.exists(path)) {
            FileUtils.remove(path);
            return;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}

