/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.jdbc.sql.SqlParser;
import com.sqlapp.jdbc.sql.SqlRegistry;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSqlRegistry
implements SqlRegistry {
    protected static final Logger loggger = LogManager.getLogger(AbstractSqlRegistry.class);
    private SqlParser sqlParser = SqlParser.getInstance();

    @Override
    public SqlNode get(String sqlId, Dialect dialect) {
        return CommonUtils.first(this.getAll(sqlId, dialect));
    }

    @Override
    public List<SqlNode> getAll(String sqlId, Dialect dialect) {
        String databaseProductName = this.getProductName(dialect);
        List<String> sqls = null;
        if (databaseProductName == null) {
            sqls = this.getInternal(sqlId);
            if (CommonUtils.isEmpty(sqls)) {
                return Collections.emptyList();
            }
        } else {
            sqls = this.getInternal(sqlId, databaseProductName);
            if (CommonUtils.isEmpty(sqls)) {
                sqls = this.getInternal(sqlId);
            }
            if (CommonUtils.isEmpty(sqls)) {
                return Collections.emptyList();
            }
        }
        List<SqlNode> result = CommonUtils.list(sqls.size());
        for (String sql : sqls) {
            if (CommonUtils.isEmpty(sql)) continue;
            SqlNode node = this.getSqlParser().parse(sql);
            result.add(node);
        }
        return result;
    }

    @Override
    public SqlNode get(String sqlId) {
        return CommonUtils.first(this.getAll(sqlId));
    }

    @Override
    public List<SqlNode> getAll(String sqlId) {
        return this.getAll(sqlId, null);
    }

    protected String getProductName(Dialect dialect) {
        if (dialect == null) {
            return null;
        }
        String databaseProductName = dialect.getProductName();
        return databaseProductName.toLowerCase();
    }

    @Override
    public void put(String sqlId, Dialect dialect, String sql) {
        String databaseProductName = this.getProductName(dialect);
        if (databaseProductName == null) {
            if (this.contains(sqlId)) {
                this.removeInternal(sqlId);
            }
            this.putInternal(sqlId, sql, new String[0]);
        } else {
            if (this.contains(sqlId, databaseProductName)) {
                this.removeInternal(sqlId, databaseProductName);
            }
            this.putInternal(sqlId, sql, databaseProductName);
        }
    }

    @Override
    public void put(String sqlId, Dialect dialect, String ... sql) {
        String databaseProductName = this.getProductName(dialect);
        if (databaseProductName == null) {
            if (this.contains(sqlId)) {
                this.removeInternal(sqlId);
            }
            this.putInternal(sqlId, null, sql);
        } else {
            if (this.contains(sqlId, databaseProductName)) {
                this.removeInternal(sqlId, databaseProductName);
            }
            this.putInternal(sqlId, databaseProductName, sql);
        }
    }

    @Override
    public void put(String sqlId, String sql) {
        this.put(sqlId, sql, null);
    }

    @Override
    public void put(String sqlId, String ... sql) {
        this.putInternal(sqlId, null, sql);
    }

    @Override
    public void remove(String sqlId, Dialect dialect) {
        String databaseProductName = this.getProductName(dialect);
        if (databaseProductName == null) {
            if (this.contains(sqlId)) {
                this.removeInternal(sqlId);
            }
        } else if (this.contains(sqlId, databaseProductName)) {
            this.removeInternal(sqlId, databaseProductName);
        }
    }

    @Override
    public void remove(String sqlId) {
        this.remove(sqlId, null);
    }

    protected abstract List<String> getInternal(String var1);

    protected abstract List<String> getInternal(String var1, String var2);

    @Override
    public abstract boolean contains(String var1);

    @Override
    public abstract boolean contains(String var1, String var2);

    protected abstract void removeInternal(String var1);

    protected abstract void removeInternal(String var1, String var2);

    protected abstract void putInternal(String var1, String var2, String ... var3);

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public void setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
    }
}

