/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.jdbc.AbstractResultSet;
import com.sqlapp.util.CaseInsensitiveGetMap;
import com.sqlapp.util.CommonUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Set;

public class ExResultSet
extends AbstractResultSet<ResultSet, Object> {
    private final CaseInsensitiveGetMap<Column> metadataMap = new CaseInsensitiveGetMap();
    private boolean checkColumns = true;
    private final Set<String> errorColumns = CommonUtils.set();

    public ExResultSet(ResultSet nativeObject, Object parentObject) {
        super(nativeObject, parentObject);
    }

    public ExResultSet(ResultSet nativeObject) {
        super(nativeObject, null);
    }

    public boolean isCheckColumns() {
        return this.checkColumns;
    }

    public void setCheckColumns(boolean checkColumns) {
        this.checkColumns = checkColumns;
    }

    protected CaseInsensitiveGetMap<Column> getMetadataMap() throws SQLException {
        if (!this.metadataMap.isEmpty()) {
            return this.metadataMap;
        }
        ResultSetMetaData metadata = ((ResultSet)this.getNativeObject()).getMetaData();
        int count = metadata.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = metadata.getColumnLabel(i);
            if (name == null) {
                name = metadata.getColumnName(i);
            }
            Column column = new Column(name);
            column.setTableName(metadata.getTableName(i));
            column.setSchemaName(metadata.getSchemaName(i));
            if (metadata.isNullable(i) == 0) {
                column.setNotNull(true);
            }
            if (metadata.isNullable(i) == 1) {
                column.setNotNull(false);
            }
            this.metadataMap.put(name, column);
        }
        return this.metadataMap;
    }

    public boolean contains(String columnLabel) throws SQLException {
        if (this.getMetadataMap().get(columnLabel) != null) {
            return true;
        }
        if (this.checkColumns) {
            if (this.errorColumns.contains(columnLabel)) {
                return false;
            }
            this.warn("columnLabel does not exists. columnLabel=[" + columnLabel + "].");
            this.errorColumns.add(columnLabel);
            return false;
        }
        return true;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return false;
        }
        return ((ResultSet)this.nativeObject).getBoolean(columnLabel);
    }

    public Boolean getBooleanValue(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        boolean ret = ((ResultSet)this.nativeObject).getBoolean(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return 0;
        }
        return ((ResultSet)this.nativeObject).getByte(columnLabel);
    }

    public Byte getByteValue(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        byte ret = ((ResultSet)this.nativeObject).getByte(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return 0;
        }
        short val = ((ResultSet)this.nativeObject).getShort(columnLabel);
        return val;
    }

    public Short getShortValue(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        short ret = ((ResultSet)this.nativeObject).getShort(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return 0;
        }
        int val = ((ResultSet)this.nativeObject).getInt(columnLabel);
        return val;
    }

    public Integer getInteger(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        int ret = ((ResultSet)this.nativeObject).getInt(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return 0L;
        }
        long val = ((ResultSet)this.nativeObject).getLong(columnLabel);
        return val;
    }

    public Long getLongValue(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        long ret = ((ResultSet)this.nativeObject).getLong(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    public Float getFloatValue(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        Float ret = Float.valueOf(((ResultSet)this.nativeObject).getFloat(columnLabel));
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    public Double getDoubleValue(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        Double ret = ((ResultSet)this.nativeObject).getDouble(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        return ret;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return 0.0f;
        }
        float val = ((ResultSet)this.nativeObject).getFloat(columnLabel);
        return val;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return 0.0;
        }
        double val = ((ResultSet)this.nativeObject).getDouble(columnLabel);
        return val;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getBigDecimal(columnLabel, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getBytes(columnLabel);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getDate(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getTimestamp(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getAsciiStream(columnLabel);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getUnicodeStream(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getBinaryStream(columnLabel);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getObject(columnLabel);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getBigDecimal(columnLabel);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        return ((ResultSet)this.nativeObject).getSQLXML(columnLabel);
    }

    @Override
    public <TT> TT getObject(String columnLabel, Class<TT> type) throws SQLException {
        if (!this.contains(columnLabel)) {
            return null;
        }
        TT object = ((ResultSet)this.nativeObject).getObject(columnLabel, type);
        if (this.wasNull()) {
            return null;
        }
        return object;
    }
}

