/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.jdbc.AbstractConnection;
import com.sqlapp.jdbc.AbstractJdbc;
import com.sqlapp.jdbc.JdbcUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class AbstractDataSource
extends AbstractJdbc<DataSource>
implements DataSource,
Closeable {
    public AbstractDataSource(DataSource nativeObject) {
        super(nativeObject);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.connectionBefore();
        Connection connection = ((DataSource)this.nativeObject).getConnection();
        return this.getConnection(connection);
    }

    protected abstract AbstractConnection getConnection(Connection var1);

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.connectionBefore();
        Connection connection = ((DataSource)this.nativeObject).getConnection(username, password);
        return this.getConnection(connection);
    }

    private void connectionBefore() {
        String url;
        String driverClassName = (String)SimpleBeanUtils.getValue(this.nativeObject, "driverClassName");
        if (driverClassName == null && (driverClassName = JdbcUtils.getDriverClassNameByUrl(url = (String)SimpleBeanUtils.getValue(this.nativeObject, "url"))) != null) {
            SimpleBeanUtils.setValue(this.nativeObject, "driverClassName", driverClassName);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return ((DataSource)this.nativeObject).getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return ((DataSource)this.nativeObject).getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        ((DataSource)this.nativeObject).setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        ((DataSource)this.nativeObject).setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ((DataSource)this.nativeObject).getParentLogger();
    }

    @Override
    public void close() throws IOException {
        if (this.nativeObject instanceof Closeable) {
            ((Closeable)((Object)this.nativeObject)).close();
        }
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return ((DataSource)this.nativeObject).createConnectionBuilder();
    }
}

