/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.exceptions;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.exceptions.CommandException;

public class InvalidValueException
extends CommandException {
    private static final long serialVersionUID = 4226531603314837670L;
    private String key;
    private Object value;

    public InvalidValueException(String message, String detail, String key, Object value, Throwable t) {
        super(InvalidValueException.createMessage(message, detail, key, value), t);
        this.key = key;
        this.value = value;
    }

    public InvalidValueException(Row row, Column column, Object value, Throwable t) {
        super(InvalidValueException.createMessage(row.getDataSourceInfo(), row.getDataSourceDetailInfo(), row.getDataSourceRowNumber(), column.getName(), value), t);
        this.key = column.getName();
        this.value = value;
    }

    private static String createMessage(String message, String detail, Number lineNumber, Object key, Object value) {
        StringBuilder builder = new StringBuilder();
        builder.append("message=");
        builder.append(message);
        if (detail != null) {
            builder.append(", detail=");
            builder.append(detail);
        }
        if (lineNumber != null) {
            builder.append(", lineNumber=");
            builder.append(lineNumber);
        }
        builder.append(", key=");
        builder.append(key);
        builder.append(", value=");
        builder.append(value);
        return builder.toString();
    }

    private static String createMessage(String message, String detail, Object key, Object value) {
        return InvalidValueException.createMessage(message, detail, null, key, value);
    }

    public Object getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }
}

