/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.util.file.FileType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.ICsvListReader;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.prefs.CsvPreference;

public enum WorkbookFileType {
    EXCEL2003{

        @Override
        public String getFileExtension() {
            return "xls";
        }

        public HSSFWorkbook createWorkbook() {
            return new HSSFWorkbook();
        }

        @Override
        public boolean isWorkbook() {
            return true;
        }
    }
    ,
    EXCEL2007{

        @Override
        public String getFileExtension() {
            return "xlsx";
        }

        @Override
        public Workbook createWorkbook() {
            return new XSSFWorkbook();
        }

        @Override
        public boolean isWorkbook() {
            return true;
        }
    }
    ,
    CALC{

        @Override
        public String getFileExtension() {
            return "ods";
        }

        public SXSSFWorkbook createWorkbook() {
            return new SXSSFWorkbook();
        }

        @Override
        public boolean isWorkbook() {
            return true;
        }
    }
    ,
    TSV{

        @Override
        public String getFileExtension() {
            return "tsv";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isCsv() {
            return true;
        }

        @Override
        public ICsvListWriter createCsvListWriter(Writer writer) {
            return new CsvListWriter(writer, CsvPreference.TAB_PREFERENCE);
        }

        @Override
        public ICsvListReader createCsvListReader(Reader reader) {
            return new CsvListReader(reader, CsvPreference.TAB_PREFERENCE);
        }

        @Override
        public FileType getFileType() {
            return FileType.TSV;
        }
    }
    ,
    CSV{

        @Override
        public String getFileExtension() {
            return "csv";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isCsv() {
            return true;
        }

        @Override
        public ICsvListWriter createCsvListWriter(Writer writer) {
            return new CsvListWriter(writer, CsvPreference.EXCEL_PREFERENCE);
        }

        @Override
        public ICsvListReader createCsvListReader(Reader reader) {
            return new CsvListReader(reader, CsvPreference.EXCEL_PREFERENCE);
        }

        @Override
        public FileType getFileType() {
            return FileType.CSV;
        }
    }
    ,
    SSV{

        @Override
        public String getFileExtension() {
            return "ssv";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isCsv() {
            return true;
        }

        @Override
        public ICsvListWriter createCsvListWriter(Writer writer) {
            return new CsvListWriter(writer, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
        }

        @Override
        public ICsvListReader createCsvListReader(Reader reader) {
            return new CsvListReader(reader, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
        }

        @Override
        public FileType getFileType() {
            return FileType.SSV;
        }
    }
    ,
    XML{

        @Override
        public String getFileExtension() {
            return "xml";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isXml() {
            return true;
        }
    }
    ,
    JSON{

        @Override
        public String getFileExtension() {
            return "json";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isJson() {
            return true;
        }
    }
    ,
    JSONL{

        @Override
        public String getFileExtension() {
            return "jsonl";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isJsonl() {
            return true;
        }
    }
    ,
    YAML{

        @Override
        public String getFileExtension() {
            return "yaml";
        }

        @Override
        public boolean isTextFile() {
            return true;
        }

        @Override
        public boolean isYaml() {
            return true;
        }
    };


    public String getFileExtension() {
        return null;
    }

    public boolean isJson() {
        return false;
    }

    public boolean isJsonl() {
        return false;
    }

    public boolean isTextFile() {
        return false;
    }

    public boolean isCsv() {
        return false;
    }

    public boolean isXml() {
        return false;
    }

    public boolean isYaml() {
        return false;
    }

    public boolean isWorkbook() {
        return false;
    }

    public Workbook createWorkbook() {
        return null;
    }

    public FileType getFileType() {
        return null;
    }

    public ICsvListWriter createCsvListWriter(Writer writer) {
        return null;
    }

    public ICsvListWriter createCsvListWriter(File file, String charset) throws IOException {
        return this.createCsvListWriter(new BufferedWriter(new FileWriter(file, Charset.forName(charset != null ? charset : "UTF8"))));
    }

    public ICsvListReader createCsvListReader(File file, String charset) throws IOException {
        return this.createCsvListReader(new BufferedReader(new FileReader(file, Charset.forName(charset != null ? charset : "UTF8"))));
    }

    public ICsvListReader createCsvListReader(Reader reader) {
        return null;
    }

    public static Workbook createWorkBook(File file) throws EncryptedDocumentException, InvalidFormatException, IOException {
        if (file.length() == 0L) {
            WorkbookFileType type = WorkbookFileType.parse(file);
            Workbook workbook = type.createWorkbook();
            return workbook;
        }
        return WorkbookFactory.create((File)file, null, (boolean)false);
    }

    public static Workbook createWorkBook(File file, String password, boolean readonly) throws EncryptedDocumentException, InvalidFormatException, IOException {
        return WorkbookFactory.create((File)file, (String)password, (boolean)readonly);
    }

    public static Workbook createWorkBook(InputStream is) throws EncryptedDocumentException, InvalidFormatException, IOException {
        return WorkbookFactory.create((InputStream)is);
    }

    public static WorkbookFileType parse(String text) {
        if (text == null) {
            return null;
        }
        String lowername = text.toLowerCase();
        for (WorkbookFileType val : WorkbookFileType.values()) {
            if (lowername.endsWith(val.getFileExtension())) {
                return val;
            }
            if (!text.equalsIgnoreCase(val.toString())) continue;
            return val;
        }
        return null;
    }

    public static WorkbookFileType parse(File file) {
        if (file == null) {
            return null;
        }
        return WorkbookFileType.parse(file.getAbsolutePath());
    }

    public static WorkbookFileType parse(Path path) {
        if (path == null) {
            return null;
        }
        return WorkbookFileType.parse(path.toFile().getAbsolutePath());
    }
}

