/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.AbstractRowListIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.DefaultPredicate;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public class ResultSetRowIteratorHandler
extends AbstractRowIteratorHandler {
    private final ResultSet resultSet;
    private Predicate<RowCollection> filter;

    public ResultSetRowIteratorHandler(ResultSet resultSet, RowValueConverter valueConverter) {
        super(valueConverter);
        this.resultSet = resultSet;
        this.filter = new DefaultPredicate<RowCollection>();
    }

    public ResultSetRowIteratorHandler(ResultSet resultSet, Predicate<RowCollection> filter, RowValueConverter valueConverter) {
        super(valueConverter);
        this.resultSet = resultSet;
        this.filter = filter;
    }

    @Override
    public Iterator<Row> iterator(RowCollection rows) {
        if (this.getFilter().test(rows)) {
            ResultSetIterator iterator = this.getResultSetIterator(rows, this.resultSet, 0);
            return iterator;
        }
        List list = CommonUtils.emptyList();
        return list.iterator();
    }

    protected ResultSetIterator getResultSetIterator(RowCollection rows, ResultSet resultSet, int index) {
        ResultSetIterator iterator = new ResultSetIterator(rows, resultSet, index, this.getRowValueConverter());
        return iterator;
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection rows, int index) {
        if (this.getFilter().test(rows)) {
            ResultSetIterator iterator = this.getResultSetIterator(rows, this.resultSet, index);
            return iterator;
        }
        List list = CommonUtils.emptyList();
        return list.listIterator();
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection rows) {
        if (this.getFilter().test(rows)) {
            ResultSetIterator iterator = this.getResultSetIterator(rows, this.resultSet, 0);
            return iterator;
        }
        List list = CommonUtils.emptyList();
        return list.listIterator();
    }

    public Predicate<RowCollection> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<RowCollection> filter) {
        this.filter = filter;
    }

    static class ColumnPosition {
        public final int index;
        public final Column column;
        public final JdbcTypeHandler jdbcTypeHandler;

        ColumnPosition(int index, Column column, JdbcTypeHandler jdbcTypeHandler) {
            this.index = index;
            this.column = column;
            this.jdbcTypeHandler = jdbcTypeHandler;
        }
    }

    public static class ResultSetIterator
    extends AbstractRowListIterator<ResultSet> {
        private final List<ColumnPosition> columnList = CommonUtils.list();
        private ResultSet resultSet;
        private Dialect dialect;

        public ResultSetIterator(RowCollection rows, ResultSet resultSet, int index, RowValueConverter valueConverter) {
            super(rows, index, valueConverter);
            this.resultSet = resultSet;
        }

        @Override
        protected void preInitialize() throws Exception {
        }

        @Override
        protected void initializeColumn() throws Exception {
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String label = resultSetMetaData.getColumnLabel(i);
                String name = resultSetMetaData.getColumnName(i);
                Column column = this.searchColumn(this.table, label);
                if (column == null) {
                    column = this.searchColumn(this.table, name);
                }
                if (column == null) continue;
                DbDataType<?> type = this.dialect.getDbDataType(column);
                if (type == null) {
                    throw new NullPointerException("type is null. column=" + column);
                }
                ColumnPosition columnPosition = new ColumnPosition(i, column, type.getJdbcTypeHandler());
                this.columnList.add(columnPosition);
            }
        }

        @Override
        protected ResultSet read() throws Exception {
            return this.resultSet;
        }

        @Override
        protected boolean hasNextInternal() throws Exception {
            return this.resultSet.next();
        }

        protected ResultSet createResultSet() throws SQLException {
            this.resultSet.setFetchSize(1000);
            return this.resultSet;
        }

        @Override
        protected void doClose() {
            DbUtils.close(this.resultSet);
            this.resultSet = null;
        }

        @Override
        protected void set(ResultSet val, Row row) throws Exception {
            int size = this.columnList.size();
            for (int i = 0; i < size; ++i) {
                ColumnPosition columnPosition = this.columnList.get(i);
                Column column = columnPosition.column;
                Object obj = columnPosition.jdbcTypeHandler.getObject(this.resultSet, columnPosition.index);
                row.put(column.getOrdinal(), obj);
            }
        }
    }
}

