/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.AbstractRowListIterator;
import com.sqlapp.data.schemas.rowiterator.JsonRowIteratorHandler;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.JsonConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class JsonLineRowIteratorHandler
extends AbstractRowIteratorHandler {
    private final File file;
    private final JsonConverter jsonConverter;

    public JsonLineRowIteratorHandler(File file, JsonConverter jsonConverter, RowValueConverter valueConverter) {
        super(valueConverter);
        this.file = file;
        this.jsonConverter = jsonConverter;
    }

    public JsonLineRowIteratorHandler(File file, JsonConverter jsonConverter) {
        super((Row r, Column c, Object v) -> v);
        this.file = file;
        this.jsonConverter = jsonConverter;
    }

    public JsonLineRowIteratorHandler(File file) {
        super((Row r, Column c, Object v) -> v);
        this.file = file;
        this.jsonConverter = new JsonConverter();
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        return new JsonRowIteratorHandler.JsonRowIterator(c, this.file, this.jsonConverter, 0L, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        return new JsonRowIteratorHandler.JsonRowIterator(c, this.file, this.jsonConverter, index, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        return (ListIterator)this.iterator(c);
    }

    public static class JsonlineRowIterator
    extends AbstractRowListIterator<Map<String, Object>> {
        private final JsonConverter jsonConverter;
        private final File file;
        private final String charset = "utf8";
        private BufferedReader reader;
        private String filename;
        private Map<String, Object> current = null;
        private boolean hasColumn = false;
        private boolean readed = false;

        JsonlineRowIterator(RowCollection c, File file, JsonConverter jsonConverter, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.file = file;
            this.jsonConverter = jsonConverter;
        }

        JsonlineRowIterator(RowCollection c, Reader reader, JsonConverter jsonConverter, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.file = null;
            this.jsonConverter = jsonConverter;
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        }

        @Override
        protected void preInitialize() throws Exception {
            if (this.file != null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "utf8"));
                this.filename = this.file.getAbsolutePath();
            } else {
                this.filename = null;
            }
        }

        @Override
        protected void initializeColumn() throws Exception {
            if (!CommonUtils.isEmpty(this.table.getColumns())) {
                this.hasColumn = true;
            }
        }

        @Override
        protected boolean hasNextInternal() throws Exception {
            this.readInternal();
            return this.current != null;
        }

        protected Map<String, Object> readInternal() throws Exception {
            if (this.readed) {
                return this.current;
            }
            String value = this.reader.readLine();
            if (!CommonUtils.isEmpty(value)) {
                this.current = this.jsonConverter.fromJsonString(value, Map.class);
            }
            this.readed = true;
            return this.current;
        }

        @Override
        protected Map<String, Object> read() throws Exception {
            this.current = this.readInternal();
            this.readed = false;
            return this.current;
        }

        @Override
        protected void set(Map<String, Object> map, Row row) throws Exception {
            row.setDataSourceInfo(this.filename);
            row.setDataSourceRowNumber(this.count + 1L);
            map.forEach((columnName, value) -> {
                Column column = this.searchColumn(this.table, (String)columnName);
                if (!this.hasColumn && column == null) {
                    column = new Column((String)columnName);
                    this.table.getColumns().add(column);
                }
                if (column != null && value != null) {
                    this.setType(column, value);
                    this.put(row, column, value);
                }
            });
        }

        private void setType(Column column, Object value) {
            if (value instanceof Boolean) {
                if (column.getDataType() == null) {
                    column.setDataType(DataType.BOOLEAN);
                }
            } else if (value instanceof Integer || value instanceof Long) {
                if (column.getDataType() == null) {
                    column.setDataType(DataType.BIGINT);
                }
            } else if (value instanceof Number) {
                if (column.getDataType() == null) {
                    column.setDataType(DataType.DECIMAL);
                    column.setLength(38L);
                    column.setScale(17);
                } else if (column.getDataType() == DataType.INT) {
                    column.setDataType(DataType.DECIMAL);
                    column.setLength(38L);
                    column.setScale(17);
                }
            } else {
                String val = value.toString();
                long len = this.getTypeLength(val);
                if (column.getDataType() == null) {
                    column.setDataType(DataType.NVARCHAR);
                    column.setLength(len);
                }
                if (column.getLength() != null) {
                    column.setLength(Math.max(len, column.getLength()));
                }
            }
        }

        @Override
        protected void doClose() {
            FileUtils.close(this.reader);
        }
    }
}

