/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.util.CommonUtils;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractListIterator
implements ListIterator<Row>,
AutoCloseable {
    private final RowValueConverter rowValueConverter;
    private final Map<String, Column> columnNameCache = CommonUtils.map();

    protected AbstractListIterator() {
        this.rowValueConverter = (r, c, v) -> v;
    }

    protected AbstractListIterator(RowValueConverter rowValueConverter) {
        this.rowValueConverter = rowValueConverter;
    }

    protected Column searchColumn(Table table, String columnName) {
        if (columnName == null) {
            return null;
        }
        Column column = this.columnNameCache.get(columnName);
        if (column != null) {
            return column;
        }
        column = (Column)table.getColumns().get(columnName);
        if (column != null) {
            this.columnNameCache.put(columnName, column);
            return column;
        }
        column = (Column)table.getColumns().get(columnName.toLowerCase());
        if (column != null) {
            this.columnNameCache.put(columnName, column);
            return column;
        }
        column = (Column)table.getColumns().get(columnName.toUpperCase());
        if (column != null) {
            this.columnNameCache.put(columnName, column);
            return column;
        }
        String replaceName = columnName.replace("_", "");
        for (Column cols : table.getColumns()) {
            if (!CommonUtils.eqIgnoreCase(replaceName, cols.getName().replace("_", ""))) continue;
            this.columnNameCache.put(columnName, cols);
            return cols;
        }
        return null;
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support hasPrevious.");
    }

    @Override
    public Row previous() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support previous.");
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support nextIndex.");
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support previousIndex.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support remove.");
    }

    @Override
    public void set(Row e) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support set.");
    }

    @Override
    public void add(Row e) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support add.");
    }

    protected RowValueConverter getRowValueConverter() {
        return this.rowValueConverter;
    }
}

