/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.data.schemas.properties.TableSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface TableProperty<T extends DbCommonObject<?>>
extends TableNameProperty<T>,
TableSchemaNameProperty<T> {
    default public Table getTable() {
        Table obj = (Table)SimpleBeanUtils.getField(this, SchemaProperties.TABLE_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setTable(obj);
        }
        return obj;
    }

    default public T setTable(Table value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getTableFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.TABLE_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getTableSchemaName() {
        return this.getTable() == null ? null : this.getTable().getSchemaName();
    }

    @Override
    default public String getTableName() {
        return this.getTable() == null ? null : this.getTable().getName();
    }

    @Override
    default public T setTableName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setTable(null);
        } else if (this.getTable() == null || !CommonUtils.eq(this.getTableName(), name)) {
            Table obj = new Table(name);
            this.setTable(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setTableSchemaName(String name) {
        if (this.getTable() == null || !CommonUtils.eq(this.getTableSchemaName(), name)) {
            Table obj = new Table();
            obj.setSchemaName(name);
            this.setTable(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

