/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.data.schemas.properties.SequenceNameProperty;
import com.sqlapp.data.schemas.properties.SequenceSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface SequenceProperty<T extends DbCommonObject<?>>
extends SequenceNameProperty<T>,
SequenceSchemaNameProperty<T> {
    default public Sequence getSequence() {
        Sequence obj = (Sequence)SimpleBeanUtils.getField(this, SchemaProperties.SEQUENCE_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setSequence(obj);
        }
        return obj;
    }

    default public T setSequence(Sequence value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getSequenceFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.SEQUENCE_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getSequenceSchemaName() {
        return this.getSequence() == null ? null : this.getSequence().getSchemaName();
    }

    @Override
    default public String getSequenceName() {
        return this.getSequence() == null ? null : this.getSequence().getName();
    }

    @Override
    default public T setSequenceName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setSequence(null);
        } else if (this.getSequence() == null || !CommonUtils.eq(this.getSequenceName(), name)) {
            Sequence obj = new Sequence(name);
            this.setSequence(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setSequenceSchemaName(String name) {
        if (this.getSequence() == null || !CommonUtils.eq(this.getSequenceSchemaName(), name)) {
            Sequence obj = new Sequence();
            obj.setSchemaName(name);
            this.setSequence(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

