/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.OperatorArgument;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.RestrictFunctionNameProperty;
import com.sqlapp.data.schemas.properties.RestrictFunctionSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface RestrictFunctionProperty<T extends DbCommonObject<?>>
extends RestrictFunctionNameProperty<T>,
RestrictFunctionSchemaNameProperty<T> {
    default public Function getRestrictFunction() {
        Function obj = (Function)SimpleBeanUtils.getField(this, SchemaProperties.RESTRICT_FUNCTION_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setRestrictFunction(obj);
        }
        return obj;
    }

    default public T setRestrictFunction(Function value) {
        if (this instanceof DbCommonObject) {
            OperatorArgument leftArgument = (OperatorArgument)SimpleBeanUtils.getField(this, "leftArgument");
            OperatorArgument rightArgument = (OperatorArgument)SimpleBeanUtils.getField(this, "rightArgument");
            value = SchemaUtils.getFunctionFromParent(value, leftArgument, rightArgument, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.RESTRICT_FUNCTION_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getRestrictFunctionSchemaName() {
        return this.getRestrictFunction() == null ? null : this.getRestrictFunction().getSchemaName();
    }

    @Override
    default public String getRestrictFunctionName() {
        return this.getRestrictFunction() == null ? null : this.getRestrictFunction().getName();
    }

    @Override
    default public T setRestrictFunctionName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setRestrictFunction(null);
        } else if (this.getRestrictFunction() == null || !CommonUtils.eq(this.getRestrictFunctionName(), name)) {
            String[] args = name.split("\\.");
            Function obj = new Function(CommonUtils.last(args));
            if (args.length > 1) {
                obj.setSchemaName(args[args.length - 2]);
            }
            this.setRestrictFunction(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setRestrictFunctionSchemaName(String schemaName) {
        if (this.getRestrictFunction() == null || !CommonUtils.eq(this.getRestrictFunctionSchemaName(), schemaName)) {
            Function obj = new Function();
            obj.setSchemaName(schemaName);
            this.setRestrictFunction(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

