/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.OperatorNameProperty;
import com.sqlapp.data.schemas.properties.OperatorSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface OperatorProperty<T extends DbCommonObject<?>>
extends OperatorNameProperty<T>,
OperatorSchemaNameProperty<T> {
    default public Operator getOperator() {
        Operator obj = (Operator)SimpleBeanUtils.getField(this, SchemaProperties.OPERATOR_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setOperator(obj);
        }
        return obj;
    }

    default public T setOperator(Operator value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getOperatorFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.OPERATOR_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getOperatorSchemaName() {
        return this.getOperator() == null ? null : this.getOperator().getSchemaName();
    }

    @Override
    default public String getOperatorName() {
        return this.getOperator() == null ? null : this.getOperator().getName();
    }

    @Override
    default public T setOperatorName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setOperator(null);
        } else if (this.getOperator() == null || !CommonUtils.eq(this.getOperatorName(), name)) {
            Operator obj = new Operator(name);
            this.setOperator(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setOperatorSchemaName(String name) {
        if (this.getOperator() == null || !CommonUtils.eq(this.getOperatorSchemaName(), name)) {
            Operator obj = new Operator();
            obj.setSchemaName(name);
            this.setOperator(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

