/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Role;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.MemberRoleNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface MemberRoleProperty<T extends DbCommonObject<?>>
extends MemberRoleNameProperty<T> {
    default public Role getMemberRole() {
        Role obj = (Role)SimpleBeanUtils.getField(this, SchemaProperties.MEMBER_ROLE_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setMemberRole(obj);
        }
        return obj;
    }

    default public T setMemberRole(Role value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getRoleFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.MEMBER_ROLE_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getMemberRoleName() {
        return this.getMemberRole() == null ? null : this.getMemberRole().getName();
    }

    @Override
    default public T setMemberRoleName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setMemberRole(null);
        } else if (this.getMemberRole() == null || !CommonUtils.eq(this.getMemberRoleName(), name)) {
            Role obj = new Role(name);
            this.setMemberRole(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

