/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.OperatorArgument;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.FunctionNameProperty;
import com.sqlapp.data.schemas.properties.FunctionSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface FunctionProperty<T extends DbCommonObject<?>>
extends FunctionNameProperty<T>,
FunctionSchemaNameProperty<T> {
    default public Function getFunction() {
        Function obj = (Function)SimpleBeanUtils.getField(this, SchemaProperties.FUNCTION_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setFunction(obj);
        }
        return obj;
    }

    default public T setFunction(Function value) {
        if (this instanceof DbCommonObject) {
            OperatorArgument leftArgument = (OperatorArgument)SimpleBeanUtils.getField(this, "leftArgument");
            OperatorArgument rightArgument = (OperatorArgument)SimpleBeanUtils.getField(this, "rightArgument");
            value = SchemaUtils.getFunctionFromParent(value, leftArgument, rightArgument, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.FUNCTION_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getFunctionSchemaName() {
        return this.getFunction() == null ? null : this.getFunction().getSchemaName();
    }

    @Override
    default public String getFunctionName() {
        return this.getFunction() == null ? null : this.getFunction().getName();
    }

    @Override
    default public T setFunctionName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setFunction(null);
        } else if (this.getFunction() == null || !CommonUtils.eq(this.getFunctionName(), name)) {
            Function table = new Function(name);
            this.setFunction(table);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setFunctionSchemaName(String name) {
        if (this.getFunction() == null || !CommonUtils.eq(this.getFunctionSchemaName(), name)) {
            Function obj = new Function();
            obj.setSchemaName(name);
            this.setFunction(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

