/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DefaultSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface DefaultSchemaProperty<T extends DbCommonObject<?>>
extends DefaultSchemaNameProperty<T> {
    default public Schema getDefaultSchema() {
        Schema obj = (Schema)SimpleBeanUtils.getField(this, SchemaProperties.DEFAULT_SCHEMA_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setDefaultSchema(obj);
        }
        return obj;
    }

    default public T setDefaultSchema(Schema value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getSchemaFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.DEFAULT_SCHEMA_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getDefaultSchemaName() {
        return this.getDefaultSchema() == null ? null : this.getDefaultSchema().getName();
    }

    @Override
    default public T setDefaultSchemaName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setDefaultSchema(null);
        } else if (this.getDefaultSchema() == null || !CommonUtils.eq(this.getDefaultSchemaName(), name)) {
            Schema obj = new Schema(name);
            this.setDefaultSchema(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

