/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.CommutativeOperatorNameProperty;
import com.sqlapp.data.schemas.properties.CommutativeOperatorSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface CommutativeOperatorProperty<T extends DbCommonObject<?>>
extends CommutativeOperatorNameProperty<T>,
CommutativeOperatorSchemaNameProperty<T> {
    default public Operator getCommutativeOperator() {
        Operator obj = (Operator)SimpleBeanUtils.getField(this, SchemaProperties.COMMUTATIVE_OPERATOR_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setCommutativeOperator(obj);
        }
        return obj;
    }

    default public T setCommutativeOperator(Operator value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getOperatorFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.COMMUTATIVE_OPERATOR_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getCommutativeOperatorSchemaName() {
        return this.getCommutativeOperator() == null ? null : this.getCommutativeOperator().getSchemaName();
    }

    @Override
    default public String getCommutativeOperatorName() {
        return this.getCommutativeOperator() == null ? null : this.getCommutativeOperator().getName();
    }

    @Override
    default public T setCommutativeOperatorName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setCommutativeOperator(null);
        } else if (this.getCommutativeOperator() == null || !CommonUtils.eq(this.getCommutativeOperatorName(), name)) {
            Operator obj = new Operator(name);
            this.setCommutativeOperator(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setCommutativeOperatorSchemaName(String name) {
        if (this.getCommutativeOperator() == null || !CommonUtils.eq(this.getCommutativeOperatorSchemaName(), name)) {
            Operator obj = new Operator();
            obj.setSchemaName(name);
            this.setCommutativeOperator(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

