/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Principal;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.UserCollection;
import com.sqlapp.data.schemas.properties.AdminProperty;
import com.sqlapp.data.schemas.properties.ExpiredAtProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LockedAtProperty;
import com.sqlapp.data.schemas.properties.LoginUserNameProperty;
import com.sqlapp.data.schemas.properties.PasswordProperty;
import com.sqlapp.data.schemas.properties.complex.DefaultSchemaProperty;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.sql.Timestamp;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class User
extends Principal<User>
implements HasParent<UserCollection>,
PasswordProperty<User>,
AdminProperty<User>,
LockedAtProperty<User>,
ExpiredAtProperty<User>,
DefaultSchemaProperty<User>,
LoginUserNameProperty<User> {
    private static final long serialVersionUID = 1L;
    private String password = null;
    private Schema defaultSchema = null;
    private String loginUserName = null;
    private Timestamp lockedAt;
    private Timestamp expiredAt;
    private boolean admin = false;

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public User setAdmin(boolean admin) {
        this.admin = admin;
        return this;
    }

    public User() {
    }

    public User(String userName) {
        super(userName);
    }

    @Override
    protected Supplier<User> newInstance() {
        return () -> new User();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof User)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        User val = (User)obj;
        if (!this.equals(SchemaProperties.DEFAULT_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOGIN_USER_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOCKED_AT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.EXPIRED_AT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PASSWORD, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ADMIN, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.DEFAULT_SCHEMA_NAME.getLabel(), this.getDefaultSchemaName());
        stax.writeAttribute(SchemaProperties.LOGIN_USER_NAME.getLabel(), this.getLoginUserName());
        stax.writeAttribute(SchemaProperties.PASSWORD.getLabel(), this.getPassword());
        stax.writeAttribute(SchemaProperties.LOCKED_AT.getLabel(), (Object)this.getLockedAt());
        stax.writeAttribute(SchemaProperties.EXPIRED_AT.getLabel(), (Object)this.getExpiredAt());
        stax.writeAttribute(SchemaProperties.ADMIN.getLabel(), (Object)this.isAdmin());
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add(SchemaProperties.DEFAULT_SCHEMA_NAME.getLabel(), this.getDefaultSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.LOGIN_USER_NAME, this.getLoginUserName());
        builder.add((ISchemaProperty)SchemaProperties.PASSWORD, this.getPassword());
        builder.add((ISchemaProperty)SchemaProperties.LOCKED_AT, (Object)this.getLockedAt());
        builder.add((ISchemaProperty)SchemaProperties.EXPIRED_AT, (Object)this.getExpiredAt());
        builder.add((ISchemaProperty)SchemaProperties.ADMIN, (Object)this.isAdmin());
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public User setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public Timestamp getLockedAt() {
        return this.lockedAt;
    }

    @Override
    public User setLockedAt(Timestamp lockedAt) {
        this.lockedAt = lockedAt;
        return (User)this.instance();
    }

    @Override
    public Timestamp getExpiredAt() {
        return this.expiredAt;
    }

    @Override
    public User setExpiredAt(Timestamp value) {
        this.expiredAt = value;
        return (User)this.instance();
    }

    @Override
    public String getLoginUserName() {
        return this.loginUserName;
    }

    @Override
    public User setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
        return this;
    }

    @Override
    public UserCollection getParent() {
        return (UserCollection)super.getParent();
    }
}

