/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IndexTypeProperty;
import com.sqlapp.data.schemas.properties.PrimaryKeyProperty;
import com.sqlapp.data.schemas.properties.complex.IndexProperty;
import com.sqlapp.data.schemas.properties.object.ReferenceColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class UniqueConstraint
extends Constraint
implements PrimaryKeyProperty<UniqueConstraint>,
IndexProperty<UniqueConstraint>,
ReferenceColumnsProperty<UniqueConstraint>,
IndexTypeProperty<UniqueConstraint> {
    private static final long serialVersionUID = 1L;
    private final Index index = new Index();
    private boolean primaryKey = (Boolean)SchemaProperties.PRIMARY_KEY.getDefaultValue();
    protected static final String PRIMARY_KEY_CONSTRAINT = SchemaProperties.PRIMARY_KEY.getLabel() + "Constraint";

    public UniqueConstraint() {
    }

    public UniqueConstraint(String name) {
        super(name);
    }

    @Override
    protected Supplier<Constraint> newInstance() {
        return () -> new UniqueConstraint();
    }

    public UniqueConstraint(String constraintName, Column column) {
        super(constraintName);
        this.primaryKey = false;
        this.getColumns().add(new ReferenceColumn(column));
    }

    public UniqueConstraint(String constraintName, boolean primaryKey) {
        super(constraintName);
        this.primaryKey = primaryKey;
    }

    public UniqueConstraint(String constraintName, boolean primaryKey, Column column) {
        super(constraintName);
        this.primaryKey = primaryKey;
        this.getColumns().add(new ReferenceColumn(column));
    }

    public UniqueConstraint(String constraintName, Column ... columns) {
        this(constraintName, false, columns);
    }

    public UniqueConstraint(String constraintName, boolean primaryKey, Column ... columns) {
        super(constraintName);
        this.primaryKey = primaryKey;
        for (Column column : columns) {
            this.getColumns().add(new ReferenceColumn(column));
        }
    }

    public UniqueConstraint(String constraintName, boolean primaryKey, ReferenceColumn ... columns) {
        super(constraintName);
        this.primaryKey = primaryKey;
        for (ReferenceColumn column : columns) {
            this.getColumns().add(column);
        }
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public UniqueConstraint setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
        if (primaryKey) {
            for (ReferenceColumn column : this.getColumns()) {
                if (column.getColumn() == null) continue;
                column.getColumn().setNotNull(true);
            }
        }
        if (this.getParent() != null) {
            UniqueConstraint uk = this.getParent().getPrimaryKeyConstraint();
            if (uk != null && uk != this) {
                uk.primaryKey = false;
            }
            this.getParent().sort();
        }
        return this;
    }

    public UniqueConstraint addColumn(String columnName) {
        if (!this.getColumns().contains(columnName)) {
            this.getColumns().add(columnName);
        }
        return this;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        if (this.getColumns().size() > 0) {
            builder.add((ISchemaProperty)SchemaObjectProperties.REFERENCE_COLUMNS, this.getColumnsString());
        }
        builder.add((ISchemaProperty)SchemaProperties.PRIMARY_KEY, (Object)this.isPrimaryKey());
        builder.add((ISchemaProperty)SchemaProperties.INDEX_TYPE, (Object)this.getIndexType());
        super.toStringDetail(builder);
    }

    @Override
    public ReferenceColumnCollection getColumns() {
        return this.getIndex().getColumns();
    }

    protected void setColumns(ReferenceColumnCollection columns) {
        if (columns != null && this.getParent() != null) {
            ConstraintCollection cc = this.getParent();
            columns.setTable(cc.getTable());
        }
        this.getIndex().setColumns(columns);
    }

    private String getColumnsString() {
        SeparatedStringBuilder sep = new SeparatedStringBuilder(", ");
        sep.setStart("(").setEnd(")");
        for (ReferenceColumn column : this.getColumns()) {
            sep.add((Object)column.getName());
        }
        return sep.toString();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (this.isPrimaryKey()) {
            stax.writeAttribute(SchemaProperties.PRIMARY_KEY.getLabel(), (Object)this.isPrimaryKey());
        }
        if (this.getIndexName() != null && !CommonUtils.eq(this.getName(), this.getIndexName())) {
            stax.writeAttribute(SchemaProperties.INDEX_NAME.getLabel(), this.getIndexName());
        }
        stax.writeAttribute(SchemaProperties.INDEX_TYPE.getLabel(), (Object)this.getIndexType());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getColumns())) {
            this.getColumns().writeXml(stax);
        }
    }

    protected void writeXmlAsPrimary(StaxWriter stax) throws XMLStreamException {
        if (!this.primaryKey) {
            return;
        }
        stax.newLine();
        stax.indent();
        stax.writeStartElement(PRIMARY_KEY_CONSTRAINT);
        this.writeName(stax);
        stax.writeAttribute(SchemaProperties.DEFERRABILITY.getLabel(), (Object)this.getDeferrability());
        stax.writeAttribute(SchemaProperties.INDEX_TYPE.getLabel(), (Object)this.getIndexType());
        this.writeCommonAttribute(stax);
        stax.addIndentLevel(1);
        if (!CommonUtils.isEmpty(this.getColumns())) {
            this.getColumns().writeXml(stax);
        }
        this.writeCommonValue(stax);
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof UniqueConstraint)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        UniqueConstraint val = (UniqueConstraint)obj;
        if (!this.equals(SchemaProperties.PRIMARY_KEY, val, equalsHandler)) {
            return false;
        }
        if (this.getParent() == null && val.getParent() == null && !this.equals(SchemaProperties.TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.REFERENCE_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.isPrimaryKey() && !this.equals(SchemaProperties.NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    public Table getTable() {
        if (this.getParent() != null) {
            return this.getParent().getTable();
        }
        return null;
    }

    @Override
    public String getTableName() {
        ConstraintCollection constraintc;
        if (this.getParent() != null && (constraintc = (ConstraintCollection)CommonUtils.cast(this.getParent())).getTable() != null) {
            return constraintc.getTable().getName();
        }
        return super.getTableName();
    }

    @Override
    public IndexType getIndexType() {
        if (this.getIndex() != null) {
            return this.getIndex().getIndexType();
        }
        return null;
    }

    @Override
    public UniqueConstraint setIndexType(IndexType indexType) {
        this.getIndex().setIndexType(indexType);
        return this;
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof UniqueConstraint)) {
            return false;
        }
        UniqueConstraint con = (UniqueConstraint)obj;
        if (this.isPrimaryKey() && con.isPrimaryKey()) {
            return true;
        }
        if (!CommonUtils.eq(this.getName(), con.getName()) && this.getParent() != null && con.getParent() != null && (this.getParent().contains(con.getName()) || con.getParent().contains(this.getName()))) {
            return false;
        }
        return CommonUtils.eq(this.getColumnsString(), con.getColumnsString());
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            builder.add(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        builder.add((ISchemaProperty)SchemaObjectProperties.REFERENCE_COLUMNS, this.getColumnsString());
        return builder.toString();
    }

    @Override
    protected UniqueConstraint instance() {
        return this;
    }

    @Override
    public UniqueConstraint setEnable(boolean bool) {
        super.setEnable(bool);
        return this.instance();
    }

    @Override
    public UniqueConstraint setDeferrability(Deferrability deferrability) {
        super.setDeferrability(deferrability);
        return this.instance();
    }

    @Override
    public UniqueConstraint setDeferrability(String deferrability) {
        super.setDeferrability(deferrability);
        return this.instance();
    }
}

