/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.TypeColumnCollection;
import com.sqlapp.data.schemas.properties.CheckProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.TypeNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class TypeColumn
extends AbstractColumn<TypeColumn>
implements HasParent<TypeColumnCollection>,
TypeNameProperty<TypeColumn>,
CheckProperty<TypeColumn> {
    private static final long serialVersionUID = 8775419796577781694L;
    private String typeName = null;
    private String check = null;

    public TypeColumn() {
    }

    public TypeColumn(String name) {
        super(name);
    }

    @Override
    protected Supplier<TypeColumn> newInstance() {
        return () -> new TypeColumn();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof TypeColumn)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        TypeColumn val = (TypeColumn)obj;
        if (!this.equals(SchemaProperties.CHECK, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        super.toStringDetail(builder);
        if (!CommonUtils.isEmpty(this.getCheck())) {
            builder.add((ISchemaProperty)SchemaProperties.CHECK, this.getCheck());
        }
    }

    @Override
    public String getCheck() {
        return this.check;
    }

    @Override
    public TypeColumn setCheck(String check) {
        this.check = check;
        return this;
    }

    @Override
    protected String getSimpleName() {
        return "column";
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.CHECK.getLabel(), this.getCheck());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
    }

    @Override
    public TypeColumnCollection getParent() {
        return (TypeColumnCollection)super.getParent();
    }

    public Type getType() {
        TypeColumnCollection columns = this.getParent();
        if (columns == null) {
            return null;
        }
        return columns.getParent();
    }

    @Override
    public String getCatalogName() {
        Type type = this.getType();
        if (type != null) {
            return null;
        }
        return super.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        Type type = this.getType();
        if (type != null) {
            return null;
        }
        return super.getSchemaName();
    }

    @Override
    public String getTypeName() {
        Type type = this.getType();
        if (type != null) {
            return type.getName();
        }
        return this.typeName;
    }

    @Override
    public TypeColumn setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }
}

