/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.TableSpaceFileCollection;
import com.sqlapp.data.schemas.properties.AutoExtensibleProperty;
import com.sqlapp.data.schemas.properties.FilePathProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.TableSpaceNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class TableSpaceFile
extends AbstractNamedObject<TableSpaceFile>
implements HasParent<TableSpaceFileCollection>,
TableSpaceNameProperty<TableSpaceFile>,
FilePathProperty<TableSpaceFile>,
AutoExtensibleProperty<TableSpaceFile> {
    private static final long serialVersionUID = 5364113040918889046L;
    private String tableSpaceName = null;
    private String filePath = null;
    private boolean autoExtensible = (Boolean)SchemaProperties.AUTO_EXTENSIBLE.getDefaultValue();

    public TableSpaceFile() {
    }

    public TableSpaceFile(String name, String filePath) {
        super(name);
    }

    @Override
    protected Supplier<TableSpaceFile> newInstance() {
        return () -> new TableSpaceFile();
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public TableSpaceFile setFilePath(String filePath) {
        this.filePath = filePath;
        return (TableSpaceFile)this.instance();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof TableSpaceFile)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        TableSpaceFile val = (TableSpaceFile)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.FILE_PATH, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.AUTO_EXTENSIBLE, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.FILE_PATH, this.getFilePath());
        builder.add((ISchemaProperty)SchemaProperties.AUTO_EXTENSIBLE, (Object)this.isAutoExtensible());
    }

    @Override
    public boolean isAutoExtensible() {
        return this.autoExtensible;
    }

    @Override
    public TableSpaceFile setAutoExtensible(boolean autoExtensible) {
        this.autoExtensible = autoExtensible;
        return this;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!CommonUtils.eq(this.getName(), this.getFilePath())) {
            stax.writeAttribute(SchemaProperties.FILE_PATH.getLabel(), this.getFilePath());
        }
        stax.writeAttribute(SchemaProperties.AUTO_EXTENSIBLE.getLabel(), (Object)this.isAutoExtensible());
    }

    @Override
    public String getTableSpaceName() {
        TableSpace parent = this.getAncestor(TableSpace.class);
        if (parent != null) {
            return parent.getName();
        }
        return this.tableSpaceName;
    }

    @Override
    public TableSpaceFile setTableSpaceName(String tableSpaceName) {
        this.tableSpaceName = tableSpaceName;
        return this;
    }

    @Override
    public TableSpaceFileCollection getParent() {
        return (TableSpaceFileCollection)super.getParent();
    }
}

