/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.regex.Pattern;

public class SchemaObjectNameHolder {
    private String catalogName = null;
    private String schemaName = null;
    private String objectName = null;
    private Pattern catalogNamePattern = null;
    private Pattern schemaNamePattern = null;
    private Pattern objectNamePattern = null;

    public SchemaObjectNameHolder() {
    }

    public SchemaObjectNameHolder(String name) {
        String[] splits = name.split("\\.");
        if (splits.length == 1) {
            this.schemaName = null;
        } else if (splits.length == 2) {
            this.schemaName = CommonUtils.first(splits);
        } else {
            throw new IllegalArgumentException("name=" + name);
        }
        this.objectName = CommonUtils.last(splits);
    }

    public boolean match(String catalogName, String schemaName, String name) {
        if (!this.matchObjectName(name)) {
            return false;
        }
        if (this.matchSchemaName(schemaName)) {
            return this.matchCatalogName(catalogName);
        }
        return false;
    }

    private boolean matchObjectName(String name) {
        if (this.objectNamePattern != null) {
            return this.objectNamePattern.matcher(name).matches();
        }
        return CommonUtils.eq(this.getObjectName(), name);
    }

    private boolean matchSchemaName(String name) {
        if (this.schemaNamePattern != null) {
            return this.schemaNamePattern.matcher(name).matches();
        }
        return this.getSchemaName() == null || CommonUtils.eq(this.getSchemaName(), name);
    }

    private boolean matchCatalogName(String name) {
        if (this.catalogNamePattern != null) {
            return this.catalogNamePattern.matcher(name).matches();
        }
        return this.getCatalogName() == null || CommonUtils.eq(this.getCatalogName(), name);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogNamePattern = catalogName != null ? (catalogName.contains("*") ? Pattern.compile(catalogName.replace("*", ".*")) : null) : null;
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaNamePattern = schemaName != null ? (schemaName.contains("*") ? Pattern.compile(schemaName.replace("*", ".*")) : null) : null;
        this.schemaName = schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectNamePattern = objectName != null ? (objectName.contains("*") ? Pattern.compile(objectName.replace("*", ".*")) : null) : null;
        this.objectName = objectName;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("catalogName", this.catalogName);
        builder.add("schemaName", this.schemaName);
        builder.add("objectName", this.objectName);
        return builder.toString();
    }
}

