/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectCollection;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.RowIteratorHandlerProperty;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class SchemaCollection
extends AbstractNamedObjectCollection<Schema>
implements HasParent<Catalog>,
RowIteratorHandlerProperty,
NewElement<Schema, SchemaCollection> {
    private static final long serialVersionUID = 4540018510759477211L;

    protected SchemaCollection() {
    }

    protected SchemaCollection(Catalog catalog) {
        super(catalog);
    }

    @Override
    protected Supplier<SchemaCollection> newInstance() {
        return () -> new SchemaCollection();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof SchemaCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        SchemaCollection val = (SchemaCollection)obj;
        if (!this.equals(SchemaProperties.PRODUCT_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_MAJOR_VERSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_MINOR_VERSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_REVISION, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public SchemaCollection clone() {
        return (SchemaCollection)super.clone();
    }

    @Override
    public Catalog getParent() {
        return (Catalog)super.getParent();
    }

    public Catalog toCatalog() {
        if (this.getParent() != null) {
            return this.getParent();
        }
        Catalog catalog = new Catalog();
        if (this.size() > 0) {
            Schema schema = (Schema)this.get(0);
            catalog.setProductName(schema.getProductName());
            catalog.setProductMajorVersion(schema.getProductMajorVersion());
            catalog.setProductMinorVersion(schema.getProductMinorVersion());
            catalog.setProductRevision(schema.getProductRevision());
            catalog.setCharacterSemantics(schema.getCharacterSemantics());
            catalog.setCollation(schema.getCollation());
            catalog.setCharacterSet(schema.getCharacterSet());
            catalog.getSchemas().addAll(this);
        }
        return catalog;
    }

    @Override
    public void setAddDbObjectPredicate(AddDbObjectPredicate addDbObjectFilter) {
        super.setAddDbObjectPredicate(addDbObjectFilter);
        for (Schema schema : this) {
            schema.setAddDbObjectFilter(addDbObjectFilter);
        }
    }

    @Override
    public void setRowIteratorHandler(RowIteratorHandler rowIteratorHandler) {
        for (Schema schema : this) {
            schema.setRowIteratorHandler(rowIteratorHandler);
        }
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
    }

    protected ProductVersionInfo getParentProductVersionInfo() {
        Catalog catalog = this.getParent();
        if (catalog == null) {
            return null;
        }
        return catalog.getProductVersionInfo();
    }

    @Override
    protected void validate() {
        super.validate();
        for (Schema schema : this) {
            for (Table table : schema.getTables()) {
                List<ForeignKeyConstraint> fks = table.getConstraints().getForeignKeyConstraints();
                for (ForeignKeyConstraint fk : fks) {
                    Table refTable;
                    Schema refSchema;
                    if (CommonUtils.eq(fk.getRelatedTableSchemaName(), table.getSchemaName()) || (refSchema = (Schema)this.get(fk.getRelatedTableSchemaName())) == null || (refTable = (Table)refSchema.getTables().get(fk.getRelatedTableName())) == null) continue;
                    refTable.addChildRelation(fk);
                }
            }
        }
    }

    @Override
    public Schema newElement() {
        return (Schema)super.newElementInternal();
    }

    @Override
    protected Supplier<Schema> getElementSupplier() {
        return () -> new Schema();
    }
}

