/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.ConstantCollection;
import com.sqlapp.data.schemas.DbLinkCollection;
import com.sqlapp.data.schemas.DimensionCollection;
import com.sqlapp.data.schemas.DomainCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.EventCollection;
import com.sqlapp.data.schemas.ExternalTableCollection;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionCollection;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.MaskCollection;
import com.sqlapp.data.schemas.Mergeable;
import com.sqlapp.data.schemas.MviewCollection;
import com.sqlapp.data.schemas.MviewLogCollection;
import com.sqlapp.data.schemas.OperatorClassCollection;
import com.sqlapp.data.schemas.OperatorCollection;
import com.sqlapp.data.schemas.Package;
import com.sqlapp.data.schemas.PackageBody;
import com.sqlapp.data.schemas.PackageBodyCollection;
import com.sqlapp.data.schemas.PackageCollection;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProcedureCollection;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.RowIteratorHandlerProperty;
import com.sqlapp.data.schemas.RuleCollection;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.SchemaXmlReaderHandler;
import com.sqlapp.data.schemas.SequenceCollection;
import com.sqlapp.data.schemas.Sortable;
import com.sqlapp.data.schemas.SynonymCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.data.schemas.TableLinkCollection;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.TriggerCollection;
import com.sqlapp.data.schemas.TypeBodyCollection;
import com.sqlapp.data.schemas.TypeCollection;
import com.sqlapp.data.schemas.ViewCollection;
import com.sqlapp.data.schemas.XmlSchemaCollection;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import com.sqlapp.data.schemas.properties.CharacterSemanticsProperty;
import com.sqlapp.data.schemas.properties.CharacterSetProperty;
import com.sqlapp.data.schemas.properties.CollationProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.ProductProperties;
import com.sqlapp.data.schemas.properties.complex.IndexTableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.LobTableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.TableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.TemporaryTableSpaceProperty;
import com.sqlapp.data.schemas.properties.object.ConstantsProperty;
import com.sqlapp.data.schemas.properties.object.DbLinksProperty;
import com.sqlapp.data.schemas.properties.object.DimensionsProperty;
import com.sqlapp.data.schemas.properties.object.DomainsProperty;
import com.sqlapp.data.schemas.properties.object.EventsProperty;
import com.sqlapp.data.schemas.properties.object.ExternalTablesProperty;
import com.sqlapp.data.schemas.properties.object.FunctionsProperty;
import com.sqlapp.data.schemas.properties.object.MasksProperty;
import com.sqlapp.data.schemas.properties.object.MviewLogsProperty;
import com.sqlapp.data.schemas.properties.object.MviewsProperty;
import com.sqlapp.data.schemas.properties.object.OperatorClassesProperty;
import com.sqlapp.data.schemas.properties.object.OperatorsProperty;
import com.sqlapp.data.schemas.properties.object.PackageBodiesProperty;
import com.sqlapp.data.schemas.properties.object.PackagesProperty;
import com.sqlapp.data.schemas.properties.object.ProceduresProperty;
import com.sqlapp.data.schemas.properties.object.RulesProperty;
import com.sqlapp.data.schemas.properties.object.SequencesProperty;
import com.sqlapp.data.schemas.properties.object.SynonymsProperty;
import com.sqlapp.data.schemas.properties.object.TableLinksProperty;
import com.sqlapp.data.schemas.properties.object.TablesProperty;
import com.sqlapp.data.schemas.properties.object.TriggersProperty;
import com.sqlapp.data.schemas.properties.object.TypeBodiesProperty;
import com.sqlapp.data.schemas.properties.object.TypesProperty;
import com.sqlapp.data.schemas.properties.object.ViewsProperty;
import com.sqlapp.data.schemas.properties.object.XmlSchemasProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Schema
extends AbstractNamedObject<Schema>
implements ProductProperties<Schema>,
CharacterSemanticsProperty<Schema>,
CollationProperty<Schema>,
CharacterSetProperty<Schema>,
Sortable,
HasParent<SchemaCollection>,
Mergeable<Schema>,
RowIteratorHandlerProperty,
TablesProperty<Schema>,
ViewsProperty<Schema>,
MviewsProperty<Schema>,
ExternalTablesProperty<Schema>,
MviewLogsProperty<Schema>,
MasksProperty<Schema>,
ProceduresProperty<Schema>,
FunctionsProperty<Schema>,
PackagesProperty<Schema>,
PackageBodiesProperty<Schema>,
TriggersProperty<Schema>,
SequencesProperty<Schema>,
DbLinksProperty<Schema>,
TableLinksProperty<Schema>,
SynonymsProperty<Schema>,
DomainsProperty<Schema>,
TypesProperty<Schema>,
TypeBodiesProperty<Schema>,
RulesProperty<Schema>,
ConstantsProperty<Schema>,
EventsProperty<Schema>,
XmlSchemasProperty<Schema>,
OperatorsProperty<Schema>,
OperatorClassesProperty<Schema>,
DimensionsProperty<Schema>,
TableSpaceProperty<Table>,
IndexTableSpaceProperty<Table>,
LobTableSpaceProperty<Table>,
TemporaryTableSpaceProperty<Table> {
    private static final long serialVersionUID = 9009394768890692341L;
    private TableCollection tables = new TableCollection(this);
    private ViewCollection views = new ViewCollection(this);
    private MviewCollection mviews = new MviewCollection(this);
    private ExternalTableCollection externalTables = new ExternalTableCollection(this);
    private MviewLogCollection mviewLogs = new MviewLogCollection(this);
    private MaskCollection masks = new MaskCollection(this);
    private ProcedureCollection procedures = new ProcedureCollection(this);
    private FunctionCollection functions = new FunctionCollection(this);
    private PackageCollection packages = new PackageCollection(this);
    private PackageBodyCollection packageBodies = new PackageBodyCollection(this);
    private TriggerCollection triggers = new TriggerCollection(this);
    private SequenceCollection sequences = new SequenceCollection(this);
    private DbLinkCollection dbLinks = new DbLinkCollection(this);
    private TableLinkCollection tableLinks = new TableLinkCollection(this);
    private SynonymCollection synonyms = new SynonymCollection(this);
    private DomainCollection domains = new DomainCollection(this);
    private TypeCollection types = new TypeCollection(this);
    private TypeBodyCollection typeBodies = new TypeBodyCollection(this);
    private RuleCollection rules = new RuleCollection(this);
    private ConstantCollection constants = new ConstantCollection(this);
    private EventCollection events = new EventCollection(this);
    private XmlSchemaCollection xmlSchemas = new XmlSchemaCollection(this);
    private OperatorCollection operators = new OperatorCollection(this);
    private OperatorClassCollection operatorClasses = new OperatorClassCollection(this);
    private DimensionCollection dimensions = new DimensionCollection(this);
    private CharacterSemantics characterSemantics = null;
    private String characterSet = null;
    private String collation = null;
    private ProductVersionInfo productVersionInfo = null;
    private TableSpace tableSpace = null;
    private TableSpace indexTableSpace = null;
    private TableSpace lobTableSpace = null;
    private TableSpace temporaryTableSpace = null;
    private Map<String, AbstractSchemaObjectCollection> objectMap = this.getChildObjectCollectionMap();

    public Schema() {
    }

    public void setAddDbObjectFilter(AddDbObjectPredicate addDbObjectFilter) {
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
            entry.getValue().setAddDbObjectPredicate(addDbObjectFilter);
        }
    }

    public Map<String, AbstractSchemaObjectCollection> getChildObjectCollectionMap() {
        Map<String, AbstractSchemaObjectCollection> map = CommonUtils.linkedMap();
        Set<ISchemaProperty> props = SchemaUtils.getSchemaObjectProperties(this.getClass());
        for (ISchemaProperty prop : props) {
            map.put(prop.getLabel(), (AbstractSchemaObjectCollection)prop.getValue(this));
        }
        return map;
    }

    public Schema(String name) {
        super(name);
    }

    @Override
    protected Supplier<Schema> newInstance() {
        return () -> new Schema();
    }

    @Override
    public TableCollection getTables() {
        return this.tables;
    }

    @Override
    public ViewCollection getViews() {
        return this.views;
    }

    @Override
    public MviewCollection getMviews() {
        return this.mviews;
    }

    @Override
    public ProcedureCollection getProcedures() {
        return this.procedures;
    }

    @Override
    public FunctionCollection getFunctions() {
        return this.functions;
    }

    @Override
    public XmlSchemaCollection getXmlSchemas() {
        return this.xmlSchemas;
    }

    @Override
    public MviewLogCollection getMviewLogs() {
        return this.mviewLogs;
    }

    @Override
    public MaskCollection getMasks() {
        return this.masks;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Schema val = (Schema)obj;
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
            String key = entry.getKey();
            AbstractSchemaObjectCollection value = val.objectMap.get(key);
            if (this.equals(key, val, (Object)entry.getValue(), (Object)value, equalsHandler)) continue;
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_MAJOR_VERSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_MINOR_VERSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRODUCT_REVISION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SET, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCharacterSet(), val.getCharacterSet()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.COLLATION, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCollation(), val.getCollation()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SEMANTICS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOB_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TEMPORARY_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
    }

    @Override
    public ExternalTableCollection getExternalTables() {
        return this.externalTables;
    }

    public void addRoutine(AbstractSchemaObject<?> routine) {
        if (routine instanceof Procedure) {
            this.getProcedures().add((Procedure)routine);
        }
        if (routine instanceof Function) {
            this.getFunctions().add((Function)routine);
        }
        if (routine instanceof Package) {
            this.getPackages().add((Package)routine);
        }
        if (routine instanceof PackageBody) {
            this.getPackageBodies().add((PackageBody)routine);
        }
    }

    @Override
    public PackageCollection getPackages() {
        return this.packages;
    }

    @Override
    public PackageBodyCollection getPackageBodies() {
        return this.packageBodies;
    }

    @Override
    public DbLinkCollection getDbLinks() {
        return this.dbLinks;
    }

    @Override
    public SequenceCollection getSequences() {
        return this.sequences;
    }

    @Override
    public SynonymCollection getSynonyms() {
        return this.synonyms;
    }

    @Override
    public TriggerCollection getTriggers() {
        return this.triggers;
    }

    public ProductVersionInfo getProductVersionInfo() {
        if (this.getCatalog() != null) {
            return this.getCatalog().getProductVersionInfo();
        }
        if (this.productVersionInfo == null) {
            this.productVersionInfo = new ProductVersionInfo();
        }
        return this.productVersionInfo;
    }

    protected void setProductVersionInfo(ProductVersionInfo productVersionInfo) {
        this.productVersionInfo = productVersionInfo;
    }

    protected ProductVersionInfo getParentProductVersionInfo() {
        Catalog parent = this.getAncestor(Catalog.class);
        if (parent == null) {
            return null;
        }
        return parent.getProductVersionInfo();
    }

    @Override
    public String getProductName() {
        if (this.getParentProductVersionInfo() != null) {
            return this.getParentProductVersionInfo().getName();
        }
        return this.getProductVersionInfo().getName();
    }

    @Override
    public Schema setProductName(String dbProductName) {
        this.getProductVersionInfo().setName(dbProductName);
        return (Schema)this.instance();
    }

    private String getParentProductName() {
        ProductVersionInfo productVersionInfo = this.getParentProductVersionInfo();
        if (productVersionInfo == null) {
            return null;
        }
        return productVersionInfo.getName();
    }

    @Override
    public Integer getProductMajorVersion() {
        if (this.getParentProductVersionInfo() != null) {
            return this.getParentProductVersionInfo().getMajorVersion();
        }
        return this.getProductVersionInfo().getMajorVersion();
    }

    private Integer getParentMajorVersion() {
        ProductVersionInfo productVersionInfo = this.getParentProductVersionInfo();
        if (productVersionInfo == null) {
            return null;
        }
        return productVersionInfo.getMajorVersion();
    }

    @Override
    public Schema setProductMajorVersion(Integer dbMajorVersion) {
        this.getProductVersionInfo().setMajorVersion(dbMajorVersion);
        return this;
    }

    @Override
    public Integer getProductMinorVersion() {
        if (this.getParentProductVersionInfo() != null) {
            return this.getParentMinorVersion();
        }
        return this.getProductVersionInfo().getMinorVersion();
    }

    private Integer getParentMinorVersion() {
        ProductVersionInfo productVersionInfo = this.getParentProductVersionInfo();
        if (productVersionInfo == null) {
            return null;
        }
        return productVersionInfo.getMinorVersion();
    }

    @Override
    public Schema setProductMinorVersion(Integer dbMinorVersion) {
        this.getProductVersionInfo().setMinorVersion(dbMinorVersion);
        return (Schema)this.instance();
    }

    @Override
    public Integer getProductRevision() {
        if (this.getParentProductVersionInfo() != null) {
            return this.getParentProductRevision();
        }
        return this.getProductVersionInfo().getRevision();
    }

    @Override
    public Schema setProductRevision(Integer revision) {
        this.getProductVersionInfo().setRevision(revision);
        return (Schema)this.instance();
    }

    private Integer getParentProductRevision() {
        ProductVersionInfo productVersionInfo = this.getParentProductVersionInfo();
        if (productVersionInfo == null) {
            return null;
        }
        return productVersionInfo.getRevision();
    }

    @Override
    public DomainCollection getDomains() {
        return this.domains;
    }

    @Override
    public TableLinkCollection getTableLinks() {
        return this.tableLinks;
    }

    @Override
    public SchemaCollection getParent() {
        return (SchemaCollection)super.getParent();
    }

    protected void setSchemas(SchemaCollection schemas) {
        this.setParent(schemas);
    }

    @Override
    public Schema setCharacterSemantics(CharacterSemantics characterSemantics) {
        this.characterSemantics = characterSemantics;
        return this;
    }

    @Override
    public Schema setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    protected Catalog getCatalog() {
        return this.getAncestor(Catalog.class);
    }

    @Override
    public Schema setCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public boolean equalsIgnoreCase(String obj1, String obj2) {
        if (this.isCaseSensitive()) {
            return CommonUtils.eq(obj1, obj2);
        }
        return CommonUtils.eqIgnoreCase(obj1, obj2);
    }

    @Override
    public Schema setCaseSensitive(boolean caseSensitive) {
        if (this.isCaseSensitive() != caseSensitive) {
            for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
                entry.getValue().setCaseSensitive(caseSensitive);
            }
        }
        super.setCaseSensitive(caseSensitive);
        return (Schema)this.instance();
    }

    @Override
    public ConstantCollection getConstants() {
        return this.constants;
    }

    @Override
    public TypeBodyCollection getTypeBodies() {
        return this.typeBodies;
    }

    @Override
    public TypeCollection getTypes() {
        return this.types;
    }

    @Override
    public EventCollection getEvents() {
        return this.events;
    }

    @Override
    public RuleCollection getRules() {
        return this.rules;
    }

    @Override
    public OperatorCollection getOperators() {
        return this.operators;
    }

    @Override
    public OperatorClassCollection getOperatorClasses() {
        return this.operatorClasses;
    }

    @Override
    public DimensionCollection getDimensions() {
        return this.dimensions;
    }

    @Override
    protected String getSimpleName() {
        return "schema";
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!CommonUtils.eqIgnoreCase(this.getParentProductName(), this.getProductName())) {
            stax.writeAttribute(SchemaProperties.PRODUCT_NAME, (Object)this);
        }
        if (!CommonUtils.eq(this.getParentMajorVersion(), this.getProductMajorVersion())) {
            stax.writeAttribute(SchemaProperties.PRODUCT_MAJOR_VERSION, (Object)this);
        }
        if (!CommonUtils.eq(this.getParentMinorVersion(), this.getProductMinorVersion())) {
            stax.writeAttribute(SchemaProperties.PRODUCT_MINOR_VERSION, (Object)this);
        }
        if (!CommonUtils.eq(this.getParentProductRevision(), this.getProductRevision())) {
            stax.writeAttribute(SchemaProperties.PRODUCT_REVISION, (Object)this);
        }
        stax.writeAttribute(SchemaProperties.TABLE_SPACE_NAME, (Object)this);
        stax.writeAttribute(SchemaProperties.INDEX_TABLE_SPACE_NAME, (Object)this);
        stax.writeAttribute(SchemaProperties.LOB_TABLE_SPACE_NAME, (Object)this);
        stax.writeAttribute(SchemaProperties.TEMPORARY_TABLE_SPACE_NAME, (Object)this);
        if (!CommonUtils.eq(SchemaUtils.getParentCharacterSemantics(this), this.getCharacterSemantics())) {
            stax.writeAttribute(SchemaProperties.CHARACTER_SEMANTICS, (Object)this);
        }
        if (!CommonUtils.eq(SchemaUtils.getParentCharacterSet(this), this.getCharacterSet())) {
            stax.writeAttribute(SchemaProperties.CHARACTER_SET, (Object)this);
        }
        if (!CommonUtils.eq(SchemaUtils.getParentCollation(this), this.getCollation())) {
            stax.writeAttribute(SchemaProperties.COLLATION, (Object)this);
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
            if (CommonUtils.isEmpty(entry.getValue())) continue;
            if (entry.getValue() instanceof TableCollection) {
                TableCollection tables = (TableCollection)entry.getValue();
                tables.writeXml(entry.getKey(), stax);
                continue;
            }
            entry.getValue().writeXml(stax);
        }
        super.writeXmlOptionalValues(stax);
    }

    protected void setSchema(AbstractSchemaObjectCollection<?> obj) {
        if (obj != null) {
            obj.setParent(this);
        }
    }

    protected Schema setTables(TableCollection tables) {
        this.tables = tables;
        this.setSchema(tables);
        return this;
    }

    protected Schema setExternalTables(ExternalTableCollection externalTables) {
        this.externalTables = externalTables;
        this.setSchema(externalTables);
        return this;
    }

    protected Schema setXmlSchemas(XmlSchemaCollection xmlSchemas) {
        this.xmlSchemas = xmlSchemas;
        this.setSchema(xmlSchemas);
        return this;
    }

    protected Schema setConstants(ConstantCollection constants) {
        this.constants = constants;
        this.setSchema(constants);
        return this;
    }

    protected Schema setMviews(MviewCollection mviews) {
        this.mviews = mviews;
        this.setSchema(mviews);
        return this;
    }

    public Schema setMviewLogs(MviewLogCollection mviewLogs) {
        this.mviewLogs = mviewLogs;
        this.setSchema(this.mviews);
        return this;
    }

    protected Schema setViews(ViewCollection views) {
        this.views = views;
        this.setSchema(views);
        return this;
    }

    protected Schema setRules(RuleCollection rules) {
        this.rules = rules;
        this.setSchema(rules);
        return this;
    }

    protected Schema setProcedures(ProcedureCollection procedures) {
        this.procedures = procedures;
        this.setSchema(procedures);
        return this;
    }

    protected Schema setFunctions(FunctionCollection functions) {
        this.functions = functions;
        this.setSchema(functions);
        return this;
    }

    protected Schema setPackages(PackageCollection packages) {
        this.packages = packages;
        this.setSchema(packages);
        return this;
    }

    protected Schema setPackageBodies(PackageBodyCollection packageBodies) {
        this.packageBodies = packageBodies;
        this.setSchema(packageBodies);
        return this;
    }

    protected Schema setTriggers(TriggerCollection triggers) {
        this.triggers = triggers;
        this.setSchema(triggers);
        return this;
    }

    protected Schema setSequences(SequenceCollection sequences) {
        this.sequences = sequences;
        this.setSchema(sequences);
        return this;
    }

    protected Schema setDbLinks(DbLinkCollection dbLinks) {
        this.dbLinks = dbLinks;
        this.setSchema(dbLinks);
        return this;
    }

    protected Schema setTableLinks(TableLinkCollection tableLinks) {
        this.tableLinks = tableLinks;
        this.setSchema(tableLinks);
        return this;
    }

    protected Schema setSynonyms(SynonymCollection synonyms) {
        this.synonyms = synonyms;
        this.setSchema(synonyms);
        return this;
    }

    protected Schema setDomains(DomainCollection domains) {
        this.domains = domains;
        this.setSchema(domains);
        return this;
    }

    protected Schema setTypes(TypeCollection types) {
        this.types = types;
        this.setSchema(types);
        return this;
    }

    protected Schema setTypeBodies(TypeBodyCollection typeBodies) {
        this.typeBodies = typeBodies;
        this.setSchema(typeBodies);
        return this;
    }

    protected Schema setOperators(OperatorCollection operators) {
        this.operators = operators;
        this.setSchema(operators);
        return this;
    }

    protected Schema setOperatorClasses(OperatorClassCollection operatorClasses) {
        this.operatorClasses = operatorClasses;
        this.setSchema(this.operators);
        return this;
    }

    protected Schema setDimensions(DimensionCollection dimensions) {
        this.dimensions = dimensions;
        this.setSchema(dimensions);
        return this;
    }

    protected Schema setEvents(EventCollection events) {
        this.events = events;
        this.setSchema(events);
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        this.getTables().validate();
        this.getTriggers().validate();
        this.getDimensions().validate();
        DoubleKeyMap partitionChildrenMap = CommonUtils.doubleKeyMap();
        for (Table table : this.getTables()) {
            List list;
            if (table.getPartitionParent() != null) {
                String schemaName = table.getPartitionParent().getTable().getSchemaName();
                if (schemaName == null) {
                    schemaName = this.getName();
                }
                if ((list = (List)partitionChildrenMap.get(schemaName, table.getPartitionParent().getTable().getName())) == null) {
                    list = CommonUtils.list();
                    partitionChildrenMap.put(schemaName, table.getPartitionParent().getTable().getName(), list);
                }
                list.add(table);
            }
            List<ForeignKeyConstraint> fks = table.getConstraints().getForeignKeyConstraints();
            list = fks.iterator();
            while (list.hasNext()) {
                Table refTable;
                ForeignKeyConstraint fk = list.next();
                if (!CommonUtils.eq(fk.getRelatedTableSchemaName(), table.getSchemaName()) || (refTable = (Table)this.getTables().get(fk.getRelatedTableName())) == null) continue;
                refTable.addChildRelation(fk);
            }
        }
        for (Map.Entry entry : partitionChildrenMap.entrySet()) {
            for (Map.Entry entryChild : entry.getValue().entrySet()) {
                Table parentTable;
                if (entry.getKey() == null || CommonUtils.eq(this.getName(), entry.getKey())) {
                    parentTable = (Table)this.getTables().get((String)entryChild.getKey());
                    parentTable.toPartitioning();
                    parentTable.getPartitioning().addAllPartitionTable((Collection)entryChild.getValue());
                    continue;
                }
                parentTable = new Table((String)entryChild.getKey());
                if ((parentTable = SchemaUtils.getTableFromParent(parentTable, this)) == null) continue;
                parentTable.toPartitioning();
                parentTable.getPartitioning().addAllPartitionTable((Collection)entryChild.getValue());
            }
        }
    }

    public boolean isEmpty() {
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Table getTable(String name) {
        Table table = (Table)this.getTables().get(name);
        if (table != null) {
            return table;
        }
        table = this.getMviews().get(name);
        if (table != null) {
            return table;
        }
        table = this.getViews().get(name);
        if (table != null) {
            return table;
        }
        return null;
    }

    @Override
    public void sort() {
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
            entry.getValue().sort();
        }
    }

    public void sort(Comparator comparator) {
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : this.objectMap.entrySet()) {
            entry.getValue().sort(comparator);
        }
    }

    @Override
    protected SchemaXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new SchemaXmlReaderHandler();
    }

    @Override
    public void setRowIteratorHandler(RowIteratorHandler rowIteratorHandler) {
        this.getTables().setRowIteratorHandler(rowIteratorHandler);
        this.getViews().setRowIteratorHandler(rowIteratorHandler);
        this.getMviews().setRowIteratorHandler(rowIteratorHandler);
    }

    @Override
    public void merge(Schema obj) {
        Map<String, AbstractSchemaObjectCollection> myMap = this.getChildObjectCollectionMap();
        Map<String, AbstractSchemaObjectCollection> objMap = obj.getChildObjectCollectionMap();
        for (Map.Entry<String, AbstractSchemaObjectCollection> entry : objMap.entrySet()) {
            AbstractSchemaObjectCollection c = entry.getValue();
            myMap.get(entry.getKey()).addAll(c);
            c.sort();
        }
    }

    public Catalog toCatalog() {
        if (this.getParent() != null) {
            return this.getParent().toCatalog();
        }
        Catalog catalog = new Catalog();
        catalog.setDialect(this.getDialect());
        catalog.setProductName(this.getProductName());
        catalog.setProductMajorVersion(this.getProductMajorVersion());
        catalog.setProductMinorVersion(this.getProductMinorVersion());
        catalog.setProductRevision(this.getProductRevision());
        catalog.setCharacterSemantics(this.getCharacterSemantics());
        catalog.setCollation(this.getCollation());
        catalog.setCharacterSet(this.getCharacterSet());
        catalog.getSchemas().add(this);
        return catalog;
    }

    @Override
    public Dialect getDialect() {
        Dialect dialect = (Dialect)SimpleBeanUtils.getField(this, "dialect");
        if (dialect == null && this.getProductVersionInfo() != null) {
            dialect = this.getProductVersionInfo().toDialect();
            this.setDialect(dialect);
        }
        return dialect;
    }

    @Override
    public Schema setDialect(Dialect dialect) {
        SimpleBeanUtils.setField(this, "dialect", dialect);
        return this;
    }
}

