/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.RuleCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableXmlReaderHandler;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.xml.AbstractSetValue;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Rule
extends AbstractSchemaObject<Rule>
implements HasParent<RuleCollection>,
TableNameProperty<Rule> {
    private static final long serialVersionUID = 4010444838360519766L;
    private Table table = null;

    public Rule() {
    }

    public Rule(String name) {
        super(name);
    }

    @Override
    protected Supplier<Rule> newInstance() {
        return () -> new Rule();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Rule)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Rule val = (Rule)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
    }

    public Table getTable() {
        if (this.getParent() != null) {
            return this.table;
        }
        this.table = this.getTableFromParent(this.table);
        return this.table;
    }

    @Override
    public String getTableName() {
        if (this.table == null) {
            return null;
        }
        return this.getTable().getName();
    }

    @Override
    public Rule setTableName(String tableName) {
        if (tableName == null) {
            this.table = null;
            return this;
        }
        Table table = new Table(tableName);
        table.setSchemaName(this.getSchemaName());
        this.table = this.getTableFromParent(table);
        return this;
    }

    public void setTable(Table table) {
        if (table != null) {
            table.setSchemaName(this.getSchemaName());
        }
        this.table = this.getTableFromParent(table);
    }

    protected Table getTableFromParent(Table table) {
        if (table == null) {
            return table;
        }
        if (this.getParent() == null) {
            return table;
        }
        Schema schema = this.getParent().getSchema();
        if (schema == null) {
            return table;
        }
        schema.getTables().get(table.getName());
        Table getTable = (Table)schema.getTables().get(table.getName());
        if (getTable != null) {
            return getTable;
        }
        return getTable;
    }

    @Override
    public Rule setSchemaName(String schemaName) {
        super.setSchemaName(schemaName);
        if (this.table != null) {
            this.table.setSchemaName(schemaName);
        }
        return this;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.TABLE_NAME.getLabel(), this.getTableName());
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    public RuleCollection getParent() {
        return (RuleCollection)super.getParent();
    }

    @Override
    protected AbstractNamedObjectXmlReaderHandler<Rule> getDbObjectXmlReaderHandler() {
        return new AbstractNamedObjectXmlReaderHandler<Rule>(this.newInstance()){

            @Override
            protected void initializeSetValue() {
                super.initializeSetValue();
                TableXmlReaderHandler handler = new TableXmlReaderHandler();
                this.register(handler.getLocalName(), new AbstractSetValue<Rule, Object>(){

                    @Override
                    public void setValue(Rule target, String name, Object value) throws XMLStreamException {
                        if (value instanceof String) {
                            target.setTableName((String)value);
                        } else if (value instanceof Table) {
                            target.setTable((Table)value);
                        }
                    }
                });
                this.registerChild(handler);
            }
        };
    }
}

