/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectCollection;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.DefaultRowIteratorHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.GetAllDbObjectEqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.Sortable;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.xml.ResultHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class RowCollection
implements DbObjectCollection<Row>,
Sortable<Row>,
HasParent<Table>,
NewElement<Row, RowCollection> {
    private static final long serialVersionUID = -185783147817960268L;
    private Table parent = null;
    private List<Row> inner = new ArrayList<Row>();
    private transient RowIteratorHandler rowIteratorHandler = null;
    private transient AddDbObjectPredicate addDbObjectPredicate = (p, c) -> c instanceof Row;
    private String SIMPLE_NAME = AbstractNamedObjectCollection.getSimpleName(this.getClass());

    protected Supplier<RowCollection> newInstance() {
        return () -> new RowCollection();
    }

    protected AddDbObjectPredicate getAddDbObjectPredicate() {
        if (this.addDbObjectPredicate == null) {
            this.addDbObjectPredicate = (p, c) -> c instanceof Row;
        }
        return this.addDbObjectPredicate;
    }

    public void setAddDbObjectFilter(AddDbObjectPredicate addDbObjectFilter) {
        this.addDbObjectPredicate = addDbObjectFilter;
    }

    public RowCollection() {
    }

    protected RowCollection(Table parent) {
        this.parent = parent;
    }

    @Override
    public boolean add(Row row) {
        if (!this.getAddDbObjectPredicate().test(this, row)) {
            return false;
        }
        row.setParent(this);
        return this.getRowList().add(row);
    }

    protected void compactionColumn(Column ... columns) {
        List<Column> colList = CommonUtils.minus(CommonUtils.list(this.getParent().getColumns()), columns);
        Column[] colArray = colList.toArray(new Column[0]);
        for (int i = 0; i < this.inner.size(); ++i) {
            this.inner.get(i).compactionColumn(colArray);
        }
    }

    protected void compactionColumn(Collection<Column> columns) {
        List<Column> colList = CommonUtils.minus(CommonUtils.list(this.getParent().getColumns()), columns);
        Column[] colArray = colList.toArray(new Column[0]);
        for (int i = 0; i < this.inner.size(); ++i) {
            this.inner.get(i).compactionColumn(colArray);
        }
    }

    @Override
    public Row get(int i) {
        return this.inner.get(i);
    }

    public List<Object> getValueList(Column column) {
        int size = this.size();
        List<Object> result = CommonUtils.list(size);
        int index = column.getOrdinal();
        for (Row row : this) {
            result.add(row.get(index));
        }
        return result;
    }

    public Set<Object> getValueSet(Column column) {
        int size = this.size();
        Set<Object> result = CommonUtils.linkedSet(size);
        int index = column.getOrdinal();
        for (Row row : this) {
            result.add(row.get(index));
        }
        return result;
    }

    public List<Object> getValueList(String columnName) {
        ColumnCollection cc = this.getAncestor(ColumnCollection.class);
        return this.getValueList((Column)cc.get(columnName));
    }

    public Set<Object> getValueSet(String columnName) {
        ColumnCollection cc = this.getAncestor(ColumnCollection.class);
        return this.getValueSet((Column)cc.get(columnName));
    }

    public List<Object[]> getValueList(Column ... columns) {
        int size = this.size();
        List<Object[]> result = CommonUtils.list(size);
        for (Row row : this) {
            Object[] vals = new Object[columns.length];
            for (int j = 0; j < columns.length; ++j) {
                vals[j] = row.get(columns[j].getOrdinal());
            }
            result.add(vals);
        }
        return result;
    }

    @Override
    public void clear() {
        this.getRowList().clear();
    }

    public boolean contains(Row o) {
        return this.getRowList().contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getRowList().isEmpty();
    }

    public boolean remove(Row row) {
        row.setParent(null);
        return this.getRowList().remove(row);
    }

    @Override
    public int size() {
        return this.getRowList().size();
    }

    protected List<Row> getRowList() {
        return this.inner;
    }

    @Override
    public Table getParent() {
        return this.parent;
    }

    protected void setParent(Table parent) {
        this.parent = parent;
    }

    protected void addColumn(Column ... columns) {
        for (int i = 0; i < this.inner.size(); ++i) {
            this.inner.get(i).addColumn(columns);
        }
    }

    @Override
    public void add(int index, Row row) {
        if (!this.getAddDbObjectPredicate().test(this, row)) {
            return;
        }
        row.setParent(this);
        this.getRowList().add(index, row);
    }

    @Override
    public boolean addAll(List<? extends Row> rows) {
        if (rows == this) {
            return false;
        }
        List targets = CommonUtils.list();
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            if (!this.getAddDbObjectPredicate().test(this, row)) continue;
            row.setParent(this);
            targets.add(row);
        }
        return this.getRowList().addAll(targets);
    }

    @Override
    public boolean addAll(Collection<? extends Row> c) {
        List targets = CommonUtils.list();
        for (Row row : c) {
            if (!this.getAddDbObjectPredicate().test(this, row)) continue;
            row.setParent(this);
            targets.add(row);
        }
        return this.getRowList().addAll(targets);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Row> c) {
        List targets = CommonUtils.list();
        for (Row row : c) {
            if (!this.getAddDbObjectPredicate().test(this, row)) continue;
            row.setParent(this);
            targets.add(row);
        }
        return this.getRowList().addAll(index, targets);
    }

    @Override
    public boolean contains(Object o) {
        return this.getRowList().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getRowList().containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.getRowList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getRowList().lastIndexOf(o);
    }

    @Override
    public boolean remove(Object o) {
        boolean bool = this.getRowList().remove(o);
        if (bool) {
            Row row = (Row)CommonUtils.cast(o);
            row.setParent(null);
        }
        return bool;
    }

    @Override
    public Row remove(int index) {
        Row row = this.getRowList().remove(index);
        if (row != null) {
            row.setParent(null);
        }
        return row;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object obj : c) {
            Row row = (Row)CommonUtils.cast(obj);
            row.setParent(null);
        }
        return this.getRowList().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getRowList().removeAll(c);
    }

    @Override
    public Row set(int index, Row row) {
        row.setParent(this);
        return this.getRowList().set(index, row);
    }

    @Override
    public List<Row> subList(int fromIndex, int toIndex) {
        return this.getRowList().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getRowList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getRowList().toArray(a);
    }

    public String toString() {
        SeparatedStringBuilder builder = new SeparatedStringBuilder("\n");
        builder.add(this.getRowList());
        return builder.toString();
    }

    @Override
    public String toStringSimple() {
        return this.toString();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.getRowIteratorHandler().iterator(this);
    }

    @Override
    public ListIterator<Row> listIterator() {
        return this.getRowIteratorHandler().listIterator(this);
    }

    @Override
    public ListIterator<Row> listIterator(int index) {
        return this.getRowIteratorHandler().listIterator(this, index);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, EqualsHandler.getInstance());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof RowCollection)) {
            return false;
        }
        if (equalsHandler.referenceEquals(this, obj)) {
            return true;
        }
        RowCollection val = (RowCollection)obj;
        if (!this.equalsElements(val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.inner);
        return builder.hashCode();
    }

    protected boolean equalsElements(RowCollection val, EqualsHandler equalsHandler) {
        if (!equalsHandler.valueEquals("size", this, val, this.inner.size(), val.inner.size(), EqualsUtils.getEqualsSupplier(this.inner.size() == val.inner.size()))) {
            return false;
        }
        int size = this.inner.size();
        for (int i = 0; i < size; ++i) {
            Row thisObj1 = this.inner.get(i);
            Row thisObj2 = null;
            if (i < val.inner.size()) {
                thisObj2 = val.inner.get(i);
            }
            if (this.equalsElement(thisObj1, thisObj2, equalsHandler)) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsElement(Row t1, Row t2, EqualsHandler equalsHandler) {
        if (t1 == null) {
            return t2 == null;
        }
        return t1.equals(t2, equalsHandler);
    }

    protected boolean likeElement(Row t1, Row t2, EqualsHandler equalsHandler) {
        if (t1 == null) {
            return t2 == null;
        }
        return t1.like(t2, equalsHandler);
    }

    protected String getSimpleName() {
        return this.SIMPLE_NAME;
    }

    public RowCollection clone() {
        RowCollection c = this.newInstance().get();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            c.add(this.inner.get(i).clone());
        }
        return c;
    }

    @Override
    public void sort() {
    }

    @Override
    public void sort(Comparator<? super Row> comparator) {
        List<Row> result = CommonUtils.list(this.inner);
        Collections.sort(result, comparator);
    }

    @Override
    public Class<Row> getType() {
        return Row.class;
    }

    @Override
    public Row find(Row obj) {
        List<UniqueConstraint> ucs = this.parent.getConstraints().getUniqueConstraints();
        if (ucs.size() == 0) {
            for (Row row : this) {
                if (!row.equals(obj)) continue;
                return obj;
            }
            return null;
        }
        UniqueConstraint uc = CommonUtils.first(ucs);
        Object[] keyValues = new Object[uc.getColumns().size()];
        ReferenceColumnCollection rcc = uc.getColumns();
        int size = rcc.size();
        for (int i = 0; i < size; ++i) {
            ReferenceColumn rc = (ReferenceColumn)rcc.get(i);
            keyValues[i] = obj.get(rc.getName());
        }
        for (Row row : this) {
            boolean find = true;
            for (int i = 0; i < size; ++i) {
                ReferenceColumn rc = (ReferenceColumn)rcc.get(i);
                Object val = row.get(rc.getName());
                if (CommonUtils.eq(keyValues[i], val)) continue;
                find = false;
                break;
            }
            if (!find) continue;
            return row;
        }
        return null;
    }

    @Override
    public Row find(Object obj) {
        return this.find((Row)obj);
    }

    @Override
    public DbObjectDifferenceCollection diff(DbObjectCollection<Row> obj) {
        DbObjectDifferenceCollection diff = new DbObjectDifferenceCollection(this, obj);
        return diff;
    }

    @Override
    public DbObjectDifferenceCollection diff(DbObjectCollection<Row> obj, EqualsHandler equalsHandler) {
        DbObjectDifferenceCollection diff = new DbObjectDifferenceCollection(this, (DbObjectCollection<?>)obj, equalsHandler);
        return diff;
    }

    @Override
    public void loadXml(Reader reader, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(reader);
        RowCollectionXmlReaderHandler handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    @Override
    public void loadXml(InputStream stream, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(stream);
        RowCollectionXmlReaderHandler handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(String path, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        InputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = FileUtils.getInputStream(path);
            if (stream == null) {
                throw new FileNotFoundException(path);
            }
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        catch (Throwable throwable) {
            FileUtils.close(bis);
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(bis);
        FileUtils.close(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(File file, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        FileInputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = new FileInputStream(file);
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        catch (Throwable throwable) {
            FileUtils.close(bis);
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(bis);
        FileUtils.close(stream);
    }

    protected RowCollectionXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new RowCollectionXmlReaderHandler();
    }

    @Override
    public void writeXml(StaxWriter stax) throws XMLStreamException {
        if (this.getRowIteratorHandler() instanceof DefaultRowIteratorHandler) {
            if (this.size() > 0) {
                this.writeXml(SchemaObjectProperties.ROWS.getLabel(), stax);
            }
        } else {
            this.writeXml(SchemaObjectProperties.ROWS.getLabel(), stax);
        }
    }

    protected void writeXml(String name, StaxWriter stax) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeStartElement(name);
        stax.addIndentLevel(1);
        ColumnCollection columns = this.getParent().getColumns();
        long beforeCount = stax.getWriteCount();
        for (Row row : this) {
            row.writeXml(stax, columns);
        }
        stax.addIndentLevel(-1);
        long endCount = stax.getWriteCount();
        if (beforeCount != endCount) {
            stax.newLine();
            stax.indent();
        }
        stax.writeEndElement();
    }

    @Override
    public void writeXml(OutputStream stream) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(stream){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(Writer writer) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(writer){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(String path) throws XMLStreamException, IOException {
        this.writeXml(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(File file) throws XMLStreamException, IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file));
            StaxWriter stax = new StaxWriter(stream);
            this.writeXml(stax);
            stream.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    protected RowIteratorHandler getRowIteratorHandler() {
        if (this.rowIteratorHandler == null) {
            this.rowIteratorHandler = new DefaultRowIteratorHandler();
        }
        return this.rowIteratorHandler;
    }

    protected void setRowIteratorHandler(RowIteratorHandler rowIteratorHandler) {
        this.rowIteratorHandler = rowIteratorHandler;
    }

    protected void setDiffAll(SeparatedStringBuilder builder) {
        SeparatedStringBuilder sepVals = new SeparatedStringBuilder(",");
        sepVals.setStart("{").setEnd("}");
        sepVals.add(this);
        builder.add((Object)sepVals.toString());
    }

    @Override
    public void applyAll(Consumer<DbObject<?>> consumer) {
        this.equals(this, new GetAllDbObjectEqualsHandler(consumer));
    }

    @Override
    public Row newElement() {
        Row row = new Row();
        row.setParent(this);
        return row;
    }
}

