/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DummyPrincipal;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Principal;
import com.sqlapp.data.schemas.Role;
import com.sqlapp.data.schemas.RoleMemberCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.AdminProperty;
import com.sqlapp.data.schemas.properties.DefaultProperty;
import com.sqlapp.data.schemas.properties.GranteeNameProperty;
import com.sqlapp.data.schemas.properties.complex.MemberRoleProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class RoleMember
extends AbstractDbObject<RoleMember>
implements AdminProperty<RoleMember>,
Comparable<RoleMember>,
HasParent<RoleMemberCollection>,
MemberRoleProperty<RoleMember>,
GranteeNameProperty<RoleMember>,
DefaultProperty<RoleMember> {
    private static final long serialVersionUID = 1L;
    private Principal<?> grantee = null;
    private Role memberRole = null;
    private boolean admin;
    private boolean _default = (Boolean)SchemaProperties.DEFAULT.getDefaultValue();

    public RoleMember() {
    }

    public RoleMember(Principal<?> grantee, Role memberRole) {
        this(grantee, memberRole, false, false);
    }

    @Override
    protected Supplier<RoleMember> newInstance() {
        return () -> new RoleMember();
    }

    public RoleMember(Principal<?> grantee, Role memberRole, boolean admin, boolean _default) {
        this.setGrantee(grantee);
        this.setMemberRole(memberRole);
        this.setAdmin(admin);
        this.setDefault(_default);
    }

    public <S extends Principal<?>> S getGrantee() {
        if (this.grantee != null && this.grantee.getParent() == null) {
            this.setGranteeFromParent(this.grantee);
        }
        return (S)this.grantee;
    }

    protected void setGranteeFromParent(Principal<?> grantee) {
        if (this.grantee == grantee) {
            return;
        }
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            this.grantee = grantee;
            return;
        }
        User getUser = (User)catalog.getUsers().get(grantee.getName());
        if (getUser != null) {
            this.grantee = getUser;
            return;
        }
        Role getRole = (Role)catalog.getRoles().get(grantee.getName());
        if (getRole != null) {
            this.grantee = getRole;
            return;
        }
        this.grantee = grantee;
    }

    @Override
    public String getGranteeName() {
        if (this.grantee == null) {
            return null;
        }
        return this.grantee.getName();
    }

    public RoleMember setGrantee(Principal<?> grantee) {
        this.grantee = grantee;
        return this;
    }

    @Override
    public RoleMember setGranteeName(String grantee) {
        this.grantee = new DummyPrincipal(grantee);
        return this;
    }

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public RoleMember setAdmin(boolean admin) {
        this.admin = admin;
        return this;
    }

    @Override
    public boolean isDefault() {
        return this._default;
    }

    @Override
    public RoleMember setDefault(boolean _default) {
        this._default = _default;
        return this;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof RoleMember)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        RoleMember val = (RoleMember)obj;
        if (!this.equals(SchemaProperties.GRANTEE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MEMBER_ROLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ADMIN, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFAULT, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof RoleMember)) {
            return false;
        }
        RoleMember cst = (RoleMember)obj;
        if (!CommonUtils.eq(this.getGranteeName(), cst.getGranteeName())) {
            return false;
        }
        return CommonUtils.eq(this.getMemberRoleName(), cst.getMemberRoleName());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.GRANTEE_NAME.getLabel(), this.getGranteeName());
        stax.writeAttribute(SchemaProperties.MEMBER_ROLE_NAME.getLabel(), this.getMemberRoleName());
        stax.writeAttribute(SchemaProperties.ADMIN.getLabel(), (Object)this.isAdmin());
        stax.writeAttribute(SchemaProperties.DEFAULT.getLabel(), (Object)this.isDefault());
    }

    @Override
    public RoleMemberCollection getParent() {
        return (RoleMemberCollection)super.getParent();
    }

    @Override
    public int compareTo(RoleMember o) {
        int ret = CommonUtils.compare(this.grantee, o.grantee);
        if (ret != 0) {
            return ret;
        }
        return CommonUtils.compare(this.memberRole, (Object)o.memberRole);
    }
}

