/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.db.sql.AbstractBean;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;

public class ProductVersionInfo
extends AbstractBean
implements Serializable {
    private static final long serialVersionUID = 6913182598920630655L;
    private String name = null;
    private Integer majorVersion = null;
    private Integer minorVersion = null;
    private Integer revision = null;

    public Dialect toDialect() {
        if (this.name == null || this.majorVersion == null || this.minorVersion == null) {
            return DialectResolver.getInstance().getDialect("standard", 0, 0, this.revision);
        }
        return DialectResolver.getInstance().getDialect(this.name, this.majorVersion, this.minorVersion, this.revision);
    }

    public String getName() {
        return this.name;
    }

    public ProductVersionInfo setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public ProductVersionInfo setMajorVersion(Integer majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public ProductVersionInfo setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public ProductVersionInfo setRevision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append(" ");
        if (this.getMajorVersion() != null) {
            builder.append(this.getMajorVersion());
            builder.append(".");
            builder.append(this.getMinorVersion());
        }
        if (this.getRevision() != null) {
            builder.append(".");
            builder.append(this.getRevision());
        }
        return builder.toString();
    }

    public String getVersionText() {
        StringBuilder builder = new StringBuilder();
        if (this.getMajorVersion() != null) {
            builder.append(this.getMajorVersion());
            builder.append(".");
            builder.append(this.getMinorVersion());
        }
        if (this.getRevision() != null) {
            builder.append(".");
            builder.append(this.getRevision());
        }
        return builder.toString();
    }

    @Override
    public ProductVersionInfo clone() {
        return (ProductVersionInfo)super.clone();
    }

    public boolean eq(Integer majorVersion, Integer minorVersion, Integer revision) {
        if (!CommonUtils.eq(this.getMajorVersion(), majorVersion)) {
            return false;
        }
        if (!CommonUtils.eq(this.getMinorVersion(), minorVersion)) {
            return false;
        }
        return CommonUtils.eq(this.getRevision(), revision);
    }

    public boolean gte(int majorVersion, int minorVersion, Integer minimumVersion) {
        if (this.eq(majorVersion, minorVersion, minimumVersion)) {
            return true;
        }
        return this.gt(majorVersion, minorVersion, minimumVersion);
    }

    public boolean gt(Integer majorVersion, Integer minorVersion, Integer revision) {
        if (this.gt(this.getMajorVersion(), majorVersion)) {
            return true;
        }
        if (!this.eq(this.getMajorVersion(), majorVersion)) {
            return false;
        }
        if (this.gt(this.getMinorVersion(), minorVersion)) {
            return true;
        }
        if (!this.eq(this.getMinorVersion(), minorVersion)) {
            return false;
        }
        return this.gt(this.getRevision(), revision);
    }

    protected boolean eq(Integer val1, Integer val2) {
        if (val1 != null) {
            return val1.equals(val2);
        }
        return val2 == null;
    }

    protected boolean gt(Integer val1, Integer val2) {
        if (val1 == null) {
            return false;
        }
        if (val2 == null) {
            return true;
        }
        return val1.compareTo(val2) > 0;
    }

    protected boolean lt(Integer val1, Integer val2) {
        if (val1 == null) {
            return true;
        }
        if (val2 == null) {
            return false;
        }
        return val1.compareTo(val2) < 0;
    }

    public boolean lt(Integer majorVersion, Integer minorVersion, Integer revision) {
        if (this.lt(this.getMajorVersion(), majorVersion)) {
            return true;
        }
        if (!this.eq(this.getMajorVersion(), majorVersion)) {
            return false;
        }
        if (this.lt(this.getMinorVersion(), minorVersion)) {
            return true;
        }
        if (!this.eq(this.getMinorVersion(), minorVersion)) {
            return false;
        }
        return this.lt(this.getRevision(), revision);
    }

    public boolean lte(int majorVersion, int minorVersion, Integer minimumVersion) {
        if (this.eq(majorVersion, minorVersion, this.revision)) {
            return true;
        }
        return this.lt(majorVersion, minorVersion, this.revision);
    }
}

