/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.Partitioning;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum PartitioningType implements EnumProperties
{
    RangeColumns("RANGE COLUMNS", "RANGE.*COLUMNS"){

        @Override
        public boolean isPangePartitioning() {
            return true;
        }
    }
    ,
    Range("RANGE", "RANGE.*"){

        @Override
        public boolean isPangePartitioning() {
            return true;
        }
    }
    ,
    Hash("HASH", "HASH.*"){

        @Override
        public boolean isSizePartitioning() {
            return true;
        }
    }
    ,
    List("LIST", "LIST.*"){

        @Override
        public boolean isListPartitioning() {
            return true;
        }
    }
    ,
    ListColumns("LIST COLUMNS", "LIST.*COLUMNS"){

        @Override
        public boolean isListPartitioning() {
            return true;
        }
    }
    ,
    LinearHash("LINEAR HASH", "Linear.*Hash"){

        @Override
        public boolean isSizePartitioning() {
            return true;
        }
    }
    ,
    Key("KEY", "Key.*"){

        @Override
        public boolean isSizePartitioning() {
            return true;
        }
    }
    ,
    LinearKey("LINEAR KEY", "Linear.*Key"){

        @Override
        public boolean isSizePartitioning() {
            return true;
        }
    };

    private final Pattern pattern;
    private final String text;
    private static final Map<PartitioningType, PartitioningType> surrogateMap;

    static void initializeSurrogateMap() {
        surrogateMap.put(Key, Hash);
        surrogateMap.put(LinearHash, Hash);
        surrogateMap.put(LinearKey, Key);
        surrogateMap.put(RangeColumns, Range);
        surrogateMap.put(Range, RangeColumns);
        surrogateMap.put(ListColumns, List);
    }

    private PartitioningType(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static PartitioningType parse(String value) {
        if (value == null) {
            return null;
        }
        for (PartitioningType partition : PartitioningType.values()) {
            Matcher matcher = partition.pattern.matcher(value);
            if (!matcher.matches()) continue;
            return partition;
        }
        return null;
    }

    public boolean isSizePartitioning() {
        return false;
    }

    public boolean isPangePartitioning() {
        return false;
    }

    public boolean isListPartitioning() {
        return false;
    }

    public PartitioningType getSurrogate() {
        if (surrogateMap.containsKey(this)) {
            return surrogateMap.get(this);
        }
        return null;
    }

    public String toExpression(Table table) {
        String column;
        if (table.getPartitionParent() == null) {
            return null;
        }
        Table parent = table.getPartitionParent().getTable();
        if (parent == null || parent.getPartitioning() == null) {
            return null;
        }
        Partitioning partitioning = parent.getPartitioning();
        if (CommonUtils.isEmpty(partitioning.getPartitioningColumns())) {
            column = "x";
        } else {
            SeparatedStringBuilder sep = new SeparatedStringBuilder();
            if (partitioning.getPartitioningColumns().size() > 1) {
                sep.setStart("(").setEnd(")");
            }
            partitioning.getPartitioningColumns().forEach(c -> sep.add((Object)c.getName()));
            column = sep.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (this.isPangePartitioning()) {
            this.appendRangeExpression(table, column, partitioning, builder);
        } else if (this.isListPartitioning()) {
            this.appendListExpression(table, column, partitioning, builder);
        }
        return builder.toString();
    }

    protected void appendRangeExpression(Table table, String column, Partitioning partitioning, StringBuilder builder) {
        if (!CommonUtils.isEmpty(table.getPartitionParent().getLowValue())) {
            if (partitioning.getPartitioningColumns().size() > 1) {
                if (table.getPartitionParent().getLowValue().startsWith("(") && table.getPartitionParent().getLowValue().endsWith(")")) {
                    builder.append(table.getPartitionParent().getLowValue());
                } else {
                    builder.append("(");
                    builder.append(table.getPartitionParent().getLowValue());
                    builder.append(")");
                }
            } else {
                builder.append(table.getPartitionParent().getLowValue());
            }
            builder.append("<=");
        }
        builder.append(column);
        if (!CommonUtils.isEmpty(table.getPartitionParent().getHighValue())) {
            builder.append("<");
            if (partitioning.getPartitioningColumns().size() > 1) {
                if (table.getPartitionParent().getHighValue().startsWith("(") && table.getPartitionParent().getHighValue().endsWith(")")) {
                    builder.append(table.getPartitionParent().getHighValue());
                } else {
                    builder.append("(");
                    builder.append(table.getPartitionParent().getHighValue());
                    builder.append(")");
                }
            } else {
                builder.append(table.getPartitionParent().getHighValue());
            }
        }
    }

    protected void appendListExpression(Table table, String column, Partitioning partitioning, StringBuilder builder) {
        if (!CommonUtils.isEmpty(table.getPartitionParent().getHighValue())) {
            builder.append(column);
            builder.append(" IN ");
            if (table.getPartitionParent().getHighValue().startsWith("(") && table.getPartitionParent().getHighValue().endsWith(")")) {
                builder.append(table.getPartitionParent().getHighValue());
            } else {
                builder.append("(");
                builder.append(table.getPartitionParent().getHighValue());
                builder.append(")");
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }

    static {
        surrogateMap = CommonUtils.enumMap(PartitioningType.class);
        PartitioningType.initializeSurrogateMap();
    }
}

