/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.util.CommonUtils;
import java.util.Locale;
import java.util.Set;

public enum Order implements EnumProperties
{
    Asc("A", "ASC"),
    Desc("D", "DESC");

    private final Set<String> valueSet;

    private Order(String ... values) {
        this.valueSet = CommonUtils.upperSet(values);
        this.valueSet.add(this.toString());
    }

    public static Order parse(String ascOrDesc) {
        if (CommonUtils.isEmpty(ascOrDesc)) {
            return null;
        }
        for (Order order : Order.values()) {
            if (!order.valueSet.contains(ascOrDesc)) continue;
            return order;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.toString().toUpperCase();
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

