/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.OperatorClass;
import com.sqlapp.data.schemas.OperatorFamilyCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.OperatorClassNameProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.StrategyNumberProperty;
import com.sqlapp.data.schemas.properties.complex.OperatorProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class OperatorFamily
extends AbstractDbObject<OperatorFamily>
implements HasParent<OperatorFamilyCollection>,
SchemaNameProperty<OperatorFamily>,
OperatorClassNameProperty<OperatorFamily>,
OperatorProperty<OperatorFamily>,
StrategyNumberProperty<OperatorFamily> {
    private static final long serialVersionUID = -3913177606695063831L;
    private String schemaName = null;
    private String operatorClassName = null;
    private Operator operator;
    private int strategyNumber = 0;
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("([^(]+)(\\(.*\\)){0,1}");

    @Override
    protected Supplier<OperatorFamily> newInstance() {
        return () -> new OperatorFamily();
    }

    @Override
    public OperatorFamily setOperatorClassName(String operatorClassName) {
        this.operatorClassName = operatorClassName;
        return (OperatorFamily)this.instance();
    }

    @Override
    public OperatorFamily setOperatorName(String value) {
        if (CommonUtils.isEmpty(value)) {
            this.operator = null;
            return this;
        }
        Matcher mathcer = FUNCTION_NAME_PATTERN.matcher(value);
        if (mathcer.matches()) {
            this.setOperator(new Operator(mathcer.group(1)));
            this.getOperator().setSpecificName(value);
        }
        return this;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.STRATEGY_NUMBER.getLabel(), (Object)this.getStrategyNumber());
        if (this.getOperator() != null && !CommonUtils.eq(this.getSchemaName(), this.getOperator().getSchemaName())) {
            stax.writeAttribute(SchemaProperties.OPERATOR_SCHEMA_NAME.getLabel(), this.getOperator().getSchemaName());
        }
        stax.writeAttribute(SchemaProperties.OPERATOR_NAME.getLabel(), this.getOperatorName());
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.STRATEGY_NUMBER, (Object)this.getStrategyNumber());
        builder.add((ISchemaProperty)SchemaProperties.OPERATOR_NAME, this.getOperatorName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof OperatorFamily)) {
            return false;
        }
        OperatorFamily val = (OperatorFamily)obj;
        if (!this.equals(SchemaProperties.OPERATOR_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.OPERATOR_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.STRATEGY_NUMBER, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof OperatorFamily)) {
            return false;
        }
        OperatorFamily cst = (OperatorFamily)obj;
        if (!CommonUtils.eq(this.getOperatorName(), cst.getOperatorName())) {
            return false;
        }
        return CommonUtils.eq(this.getStrategyNumber(), cst.getStrategyNumber());
    }

    @Override
    public OperatorFamilyCollection getParent() {
        return (OperatorFamilyCollection)super.getParent();
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String getSchemaName() {
        OperatorClass oc = this.getAncestor(OperatorClass.class);
        if (oc != null) {
            return oc.getSchemaName();
        }
        return this.schemaName;
    }

    @Override
    public String getOperatorClassName() {
        OperatorClass parent = this.getAncestor(OperatorClass.class);
        if (parent != null) {
            return parent.getName();
        }
        return this.operatorClassName;
    }

    @Override
    public int getStrategyNumber() {
        return this.strategyNumber;
    }

    @Override
    public OperatorFamily setStrategyNumber(int strategyNumber) {
        this.strategyNumber = strategyNumber;
        return this;
    }

    @Override
    public int compareTo(OperatorFamily o) {
        if (this.getStrategyNumber() > o.getStrategyNumber()) {
            return 1;
        }
        if (this.getStrategyNumber() < o.getStrategyNumber()) {
            return -1;
        }
        return 0;
    }

    @Override
    public OperatorFamily setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return (OperatorFamily)this.instance();
    }
}

