/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum OnNullCall implements EnumProperties
{
    ReturnsNullOnNullInput("RETURNS NULL ON NULL INPUT", "RETURNS\\s*NULL\\s*ON\\s*NULL\\s*INPUT"),
    CalledOnNullInput("CALLED ON NULL INPUT", "CALLED\\s*ON\\s*NULL\\s*INPUT"){

        @Override
        public boolean isDefault() {
            return true;
        }
    };

    private final Pattern pattern;
    private final String text;

    private OnNullCall(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public boolean isDefault() {
        return false;
    }

    public static OnNullCall parse(String text) {
        if (text == null) {
            return null;
        }
        for (OnNullCall rule : OnNullCall.values()) {
            Matcher matcher = rule.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return rule;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

