/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.MviewLogCollection;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.properties.CommitScnBasedProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IncludeNewValuesProperty;
import com.sqlapp.data.schemas.properties.MasterTableNameProperty;
import com.sqlapp.data.schemas.properties.MasterTableSchemaNameProperty;
import com.sqlapp.data.schemas.properties.PurgeAsynchronousProperty;
import com.sqlapp.data.schemas.properties.PurgeDeferredProperty;
import com.sqlapp.data.schemas.properties.PurgeIntervalProperty;
import com.sqlapp.data.schemas.properties.PurgeStartProperty;
import com.sqlapp.data.schemas.properties.SaveFilterColumnsProperty;
import com.sqlapp.data.schemas.properties.SaveObjectIdProperty;
import com.sqlapp.data.schemas.properties.SavePrimaryKeyProperty;
import com.sqlapp.data.schemas.properties.SaveRowIdsProperty;
import com.sqlapp.data.schemas.properties.SaveSequenceProperty;
import com.sqlapp.data.schemas.properties.complex.TableSpaceProperty;
import com.sqlapp.data.schemas.properties.object.ReferenceColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.sql.Timestamp;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class MviewLog
extends AbstractSchemaObject<MviewLog>
implements HasParent<MviewLogCollection>,
MasterTableSchemaNameProperty<MviewLog>,
MasterTableNameProperty<MviewLog>,
ReferenceColumnsProperty<MviewLog>,
SaveRowIdsProperty<MviewLog>,
SavePrimaryKeyProperty<MviewLog>,
SaveObjectIdProperty<MviewLog>,
SaveFilterColumnsProperty<MviewLog>,
SaveSequenceProperty<MviewLog>,
IncludeNewValuesProperty<MviewLog>,
TableSpaceProperty<MviewLog>,
PurgeAsynchronousProperty<MviewLog>,
PurgeDeferredProperty<MviewLog>,
PurgeStartProperty<MviewLog>,
PurgeIntervalProperty<MviewLog>,
CommitScnBasedProperty<MviewLog> {
    private static final long serialVersionUID = -2636864307288766192L;
    private ReferenceColumnCollection columns = new ReferenceColumnCollection(this);
    private Table masterTable = null;
    private boolean saveRowIds = (Boolean)SchemaProperties.SAVE_ROW_IDS.getDefaultValue();
    private boolean savePrimaryKey = (Boolean)SchemaProperties.SAVE_PRIMARY_KEY.getDefaultValue();
    private boolean saveObjectId = (Boolean)SchemaProperties.SAVE_OBJECT_ID.getDefaultValue();
    private boolean saveFilterColumns = (Boolean)SchemaProperties.SAVE_FILTER_COLUMNS.getDefaultValue();
    private boolean saveSequence = (Boolean)SchemaProperties.SAVE_SEQUENCE.getDefaultValue();
    private boolean includeNewValues = (Boolean)SchemaProperties.INCLUDE_NEW_VALUES.getDefaultValue();
    private TableSpace tableSpace = null;
    private boolean purgeAsynchronous = (Boolean)SchemaProperties.PURGE_ASYNCHRONOUS.getDefaultValue();
    private boolean purgeDeferred = (Boolean)SchemaProperties.PURGE_DEFERRED.getDefaultValue();
    private Timestamp purgeStart = null;
    private String purgeInterval = null;
    private boolean commitScnBased = (Boolean)SchemaProperties.COMMIT_SCN_BASED.getDefaultValue();

    protected MviewLog() {
    }

    public MviewLog(String name) {
        super(name);
    }

    @Override
    protected Supplier<MviewLog> newInstance() {
        return () -> new MviewLog();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.MASTER_TABLE_NAME, this.getMasterTableName());
        builder.add((ISchemaProperty)SchemaProperties.SAVE_ROW_IDS, (Object)this.isSaveRowIds());
        builder.add((ISchemaProperty)SchemaProperties.PRIMARY_KEY, (Object)this.isSavePrimaryKey());
        builder.add((ISchemaProperty)SchemaProperties.SAVE_OBJECT_ID, (Object)this.isSaveObjectId());
        builder.add((ISchemaProperty)SchemaProperties.SAVE_FILTER_COLUMNS, (Object)this.isSaveFilterColumns());
        builder.add((ISchemaProperty)SchemaProperties.SAVE_SEQUENCE, (Object)this.isSaveSequence());
        builder.add((ISchemaProperty)SchemaProperties.INCLUDE_NEW_VALUES, (Object)this.isIncludeNewValues());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_SPACE_NAME, this.getTableSpaceName());
        builder.add((ISchemaProperty)SchemaProperties.PURGE_ASYNCHRONOUS, (Object)this.isPurgeAsynchronous());
        builder.add((ISchemaProperty)SchemaProperties.PURGE_DEFERRED, (Object)this.isPurgeDeferred());
        builder.add((ISchemaProperty)SchemaProperties.PURGE_START, (Object)this.getPurgeStart());
        builder.add((ISchemaProperty)SchemaProperties.PURGE_INTERVAL, this.getPurgeInterval());
        builder.add((ISchemaProperty)SchemaProperties.COMMIT_SCN_BASED, (Object)this.isCommitScnBased());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof MviewLog)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        MviewLog val = (MviewLog)obj;
        if (!this.equals(SchemaObjectProperties.REFERENCE_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MASTER_TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SAVE_ROW_IDS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRIMARY_KEY, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SAVE_OBJECT_ID, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SAVE_FILTER_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SAVE_SEQUENCE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INCLUDE_NEW_VALUES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PURGE_ASYNCHRONOUS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PURGE_DEFERRED, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PURGE_START, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PURGE_INTERVAL, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMMIT_SCN_BASED, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!CommonUtils.eq(this.getMasterTableSchemaName(), this.getSchemaName())) {
            stax.writeAttribute(SchemaProperties.MASTER_TABLE_SCHEMA_NAME.getLabel(), this.getMasterTableSchemaName());
        }
        stax.writeAttribute(SchemaProperties.MASTER_TABLE_NAME.getLabel(), this.getMasterTableName());
        stax.writeAttribute(SchemaProperties.SAVE_ROW_IDS.getLabel(), (Object)this.isSaveRowIds());
        stax.writeAttribute(SchemaProperties.SAVE_PRIMARY_KEY.getLabel(), (Object)this.isSavePrimaryKey());
        stax.writeAttribute(SchemaProperties.SAVE_OBJECT_ID.getLabel(), (Object)this.isSaveObjectId());
        stax.writeAttribute(SchemaProperties.SAVE_FILTER_COLUMNS.getLabel(), (Object)this.isSaveFilterColumns());
        stax.writeAttribute(SchemaProperties.SAVE_SEQUENCE.getLabel(), (Object)this.isSaveSequence());
        stax.writeAttribute(SchemaProperties.INCLUDE_NEW_VALUES.getLabel(), (Object)this.isIncludeNewValues());
        stax.writeAttribute(SchemaProperties.TABLE_SPACE_NAME.getLabel(), this.getTableSpaceName());
        stax.writeAttribute(SchemaProperties.PURGE_ASYNCHRONOUS.getLabel(), (Object)this.isPurgeAsynchronous());
        stax.writeAttribute(SchemaProperties.PURGE_DEFERRED.getLabel(), (Object)this.isPurgeDeferred());
        stax.writeAttribute(SchemaProperties.PURGE_START.getLabel(), (Object)this.getPurgeStart());
        stax.writeAttribute(SchemaProperties.PURGE_INTERVAL.getLabel(), this.getPurgeInterval());
        stax.writeAttribute(SchemaProperties.COMMIT_SCN_BASED.getLabel(), (Object)this.isCommitScnBased());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.columns)) {
            this.columns.writeXml(stax);
        }
    }

    public Table getMasterTable() {
        if (this.masterTable != null && this.masterTable.getParent() == null) {
            this.setTableFromParent(this.masterTable);
        }
        return this.masterTable;
    }

    @Override
    public String getMasterTableName() {
        if (this.getMasterTable() == null) {
            return null;
        }
        return this.masterTable.getName();
    }

    public MviewLog setMasterTable(Table masterTable) {
        this.setTableFromParent(masterTable);
        this.columns.setTable(masterTable);
        return this;
    }

    protected void setColumns(ReferenceColumnCollection columns) {
        this.columns = columns;
        if (this.columns != null) {
            this.columns.setParent(this);
        }
    }

    @Override
    public MviewLog setMasterTableName(String masterTableName) {
        if (CommonUtils.isEmpty(masterTableName)) {
            this.setMasterTable(null);
        } else {
            if (this.getMasterTable() == null) {
                this.setMasterTable(new Table());
            }
            this.getMasterTable().setName(masterTableName);
        }
        return (MviewLog)this.instance();
    }

    @Override
    public String getMasterTableSchemaName() {
        if (this.getMasterTable() == null) {
            return null;
        }
        return this.getMasterTable().getSchemaName();
    }

    @Override
    public MviewLog setMasterTableSchemaName(String masterTableSchemaName) {
        if (this.getMasterTable() == null) {
            this.setMasterTable(new Table());
        }
        this.getMasterTable().setSchemaName(masterTableSchemaName);
        return this;
    }

    private void setTableFromParent(Table masterTable) {
        if (this.masterTable == masterTable) {
            return;
        }
        if (this.getParent() == null) {
            this.masterTable = masterTable;
            return;
        }
        if (this.getParent().getSchema() == null) {
            this.masterTable = masterTable;
            return;
        }
        Table getTable = this.getParent().getSchema().getTable(masterTable.getName());
        if (getTable != null) {
            this.masterTable = getTable;
            return;
        }
        this.masterTable = masterTable;
    }

    @Override
    public boolean isSaveRowIds() {
        return this.saveRowIds;
    }

    @Override
    public MviewLog setSaveRowIds(boolean saveRowIds) {
        this.saveRowIds = saveRowIds;
        return this;
    }

    @Override
    public boolean isSavePrimaryKey() {
        return this.savePrimaryKey;
    }

    @Override
    public MviewLog setSavePrimaryKey(boolean savePrimaryKey) {
        this.savePrimaryKey = savePrimaryKey;
        return this;
    }

    @Override
    public boolean isSaveObjectId() {
        return this.saveObjectId;
    }

    @Override
    public MviewLog setSaveObjectId(boolean saveObjectId) {
        this.saveObjectId = saveObjectId;
        return this;
    }

    @Override
    public boolean isSaveFilterColumns() {
        return this.saveFilterColumns;
    }

    @Override
    public MviewLog setSaveFilterColumns(boolean saveFilterColumns) {
        this.saveFilterColumns = saveFilterColumns;
        return this;
    }

    @Override
    public boolean isSaveSequence() {
        return this.saveSequence;
    }

    @Override
    public MviewLog setSaveSequence(boolean saveSequence) {
        this.saveSequence = saveSequence;
        return this;
    }

    @Override
    public boolean isIncludeNewValues() {
        return this.includeNewValues;
    }

    @Override
    public MviewLog setIncludeNewValues(boolean includeNewValues) {
        this.includeNewValues = includeNewValues;
        return this;
    }

    @Override
    public boolean isPurgeAsynchronous() {
        return this.purgeAsynchronous;
    }

    @Override
    public MviewLog setPurgeAsynchronous(boolean purgeAsynchronous) {
        this.purgeAsynchronous = purgeAsynchronous;
        return this;
    }

    @Override
    public boolean isPurgeDeferred() {
        return this.purgeDeferred;
    }

    @Override
    public MviewLog setPurgeDeferred(boolean purgeDeferred) {
        this.purgeDeferred = purgeDeferred;
        return this;
    }

    @Override
    public Timestamp getPurgeStart() {
        return this.purgeStart;
    }

    @Override
    public MviewLog setPurgeStart(Timestamp purgeStart) {
        this.purgeStart = purgeStart;
        return this;
    }

    @Override
    public String getPurgeInterval() {
        return this.purgeInterval;
    }

    @Override
    public MviewLog setPurgeInterval(String purgeInterval) {
        this.purgeInterval = purgeInterval;
        return this;
    }

    @Override
    public boolean isCommitScnBased() {
        return this.commitScnBased;
    }

    @Override
    public MviewLog setCommitScnBased(boolean commitScnBased) {
        this.commitScnBased = commitScnBased;
        return this;
    }

    @Override
    public MviewLogCollection getParent() {
        return (MviewLogCollection)super.getParent();
    }

    @Override
    public ReferenceColumnCollection getColumns() {
        return this.columns;
    }

    @Override
    protected void validate() {
        super.validate();
        this.setTableSpace(this.getTableSpaceFromParent(this.tableSpace));
    }
}

