/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class InheritCollection
extends AbstractSchemaObjectCollection<Table>
implements HasParent<Table> {
    private static final long serialVersionUID = -9212319248422513405L;

    protected InheritCollection() {
    }

    protected InheritCollection(Table derived) {
        super(derived);
    }

    @Override
    protected Supplier<InheritCollection> newInstance() {
        return () -> new InheritCollection();
    }

    @Override
    public Schema getSchema() {
        return this.getParent().getSchema();
    }

    @Override
    protected void renew() {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            for (int i = 0; i < this.inner.size(); ++i) {
                Table table = (Table)this.inner.get(i);
                Table getTable = null;
                if (table.getSchemaName() != null && !CommonUtils.eq(table.getSchemaName(), this.getParent().getSchemaName())) {
                    Schema schema;
                    if (this.getParent().getSchema() != null && this.getParent().getSchema().getParent() != null && (schema = (Schema)this.getParent().getSchema().getParent().get(table.getSchemaName())) != null) {
                        getTable = schema.getTable(table.getName());
                    }
                } else {
                    getTable = (Table)this.getParent().getParent().get(table.getName());
                }
                if (getTable == null) continue;
                this.inner.set(i, getTable);
            }
        }
        super.renew();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof InheritCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected boolean equalsElement(Table t1, Table t2, EqualsHandler equalsHandler) {
        if (!this.equals(SchemaProperties.TABLE_NAME, t1, t2, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.SCHEMA_NAME, t1, t2, equalsHandler);
    }

    @Override
    public InheritCollection clone() {
        InheritCollection clone = new InheritCollection();
        for (Table table : this) {
            clone.add((Table)table.clone());
        }
        return clone;
    }

    @Override
    public void writeXml(String name, StaxWriter stax) throws XMLStreamException {
        int size = this.size();
        stax.newLine();
        stax.indent();
        stax.writeStartElement(name);
        stax.addIndentLevel(1);
        for (int i = 0; i < size; ++i) {
            Table obj = (Table)this.get(i);
            boolean bool = !CommonUtils.eq(this.getParent().getSchemaName(), obj.getSchemaName());
            obj.writeSimpleXml(stax, bool);
        }
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    @Override
    public Table getParent() {
        return (Table)super.getParent();
    }

    @Override
    protected void initializeSchemaInfo(Table e) {
    }

    @Override
    protected void setElementParent(Table e) {
    }

    @Override
    protected Supplier<Table> getElementSupplier() {
        return null;
    }
}

