/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.util.CommonUtils;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum IndexType implements EnumProperties
{
    BTree("BTREE", "(NORMAL|Btree)"),
    RTree("RTREE"),
    TTree("TTREE"),
    BlockRange("BRIN", "(BRIN|BLOCK.*RANGE.*)"),
    Hash("HASH"),
    Gist("GIST"),
    Gin("GIN"),
    Spatial("SPATIAL"),
    Xml("XML"),
    Clustered("CLUSTERED"){

        @Override
        public boolean isClusterd() {
            return true;
        }
    }
    ,
    ClusteredColumnStore("CLUSTERED", "CLUSTERED\\s*COLUMN\\s*STORE"){

        @Override
        public boolean isClusterd() {
            return true;
        }

        @Override
        public boolean isColumnStore() {
            return true;
        }
    }
    ,
    NonClusteredColumnStore("NONCLUSTERED COLUMNSTORE", "CLUSTERED\\s*COLUMN\\s*STORE"){

        @Override
        public boolean isColumnStore() {
            return true;
        }
    }
    ,
    BitMap("BITMAP"){

        @Override
        public boolean isBitMap() {
            return true;
        }
    }
    ,
    Function("FUNCTION NORMAL", "FUNCTION.*NORMAL"){

        @Override
        public boolean isFunction() {
            return true;
        }
    }
    ,
    FunctionBitmap("FUNCTION BITMAP", "FUNCTION.*BITMAP"){

        @Override
        public boolean isFunction() {
            return true;
        }

        @Override
        public boolean isBitMap() {
            return true;
        }
    }
    ,
    FunctionDomain("FUNCTION DOMAIN", "FUNCTION.*DOMAIN"){

        @Override
        public boolean isFunction() {
            return true;
        }
    }
    ,
    FullText("FULLTEXT", "FULL*.*TEXT"),
    Domain("DOMAIN"),
    Other("OTHER");

    private static Map<IndexType, IndexType> surrogateMap;
    private final String text;
    private final Pattern pattern;
    private static Map<String, IndexType> typeCache;

    static void initializeSurrogateMap() {
        surrogateMap.put(TTree, BTree);
        surrogateMap.put(RTree, BTree);
        surrogateMap.put(Hash, BTree);
        surrogateMap.put(Gist, BTree);
        surrogateMap.put(Gin, BTree);
        surrogateMap.put(Spatial, BTree);
        surrogateMap.put(Clustered, BTree);
        surrogateMap.put(ClusteredColumnStore, Clustered);
        surrogateMap.put(BitMap, BTree);
        surrogateMap.put(FunctionBitmap, Function);
        surrogateMap.put(FunctionDomain, Function);
    }

    private IndexType(String text) {
        this.text = text.toUpperCase();
        this.pattern = Pattern.compile(text, 2);
    }

    private IndexType(String text, String pattenText) {
        this.text = text;
        this.pattern = Pattern.compile(pattenText, 2);
    }

    public static IndexType parse(String text) {
        if (CommonUtils.isEmpty(text)) {
            return null;
        }
        IndexType type = typeCache.get(text);
        if (type != null) {
            return type;
        }
        for (IndexType enm : IndexType.values()) {
            Matcher matcher = enm.pattern.matcher(text);
            if (!matcher.matches()) continue;
            typeCache.put(text, enm);
            return enm;
        }
        return null;
    }

    public IndexType getSurrogate() {
        if (surrogateMap.containsKey(this)) {
            return surrogateMap.get(this);
        }
        return null;
    }

    public boolean isClusterd() {
        return false;
    }

    public boolean isBitMap() {
        return false;
    }

    public boolean isColumnStore() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }

    static {
        surrogateMap = CommonUtils.map();
        IndexType.initializeSurrogateMap();
        typeCache = CommonUtils.upperMap();
    }
}

