/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum FunctionType implements EnumProperties
{
    Aggregate("AGGREGATE", "AG.*"){

        @Override
        public boolean isAggregate() {
            return true;
        }
    }
    ,
    Window("WINDOW", "WINDOW.*"),
    Table("TABLE", "TABLE.*"){

        @Override
        public boolean isTable() {
            return true;
        }
    }
    ,
    Row("ROW", "ROW.*"){

        @Override
        public boolean isRow() {
            return true;
        }
    }
    ,
    Scalar("", ".*"){

        @Override
        public boolean isScalar() {
            return true;
        }
    };

    private final Pattern pattern;
    private final String text;

    private FunctionType(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public boolean isAggregate() {
        return false;
    }

    public boolean isTable() {
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isRow() {
        return false;
    }

    public static FunctionType parse(String text) {
        if (text == null) {
            return null;
        }
        for (FunctionType rule : FunctionType.values()) {
            Matcher matcher = rule.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return rule;
        }
        return null;
    }

    public String getValue() {
        return this.text;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

